/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.dataflow.LocalFlowSpec;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class UriCreatedWithHttpScheme
extends Recipe {
    private static final MethodMatcher URI_CREATE = new MethodMatcher("java.net.URI create(..)");
    private static final MethodMatcher STRING_REPLACE = new MethodMatcher("java.lang.String replace(..)");
    private static final LocalFlowSpec<J.Literal, J.MethodInvocation> INSECURE_URI = new LocalFlowSpec<J.Literal, J.MethodInvocation>(){

        @Override
        public boolean isSource(J.Literal expr) {
            return expr.getValue() != null && expr.getValue().toString().startsWith("http://");
        }

        @Override
        public boolean isSink(J.MethodInvocation expr) {
            return URI_CREATE.matches(expr);
        }

        @Override
        public boolean isBarrierGuard(Expression expr) {
            return STRING_REPLACE.matches(expr);
        }
    };

    public String getDisplayName() {
        return "URIs created with an HTTP scheme";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod<ExecutionContext>(URI_CREATE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Literal visitLiteral(J.Literal literal, ExecutionContext executionContext) {
                J l = super.visitLiteral(literal, executionContext);
                if (!this.dataflow().findSinks(INSECURE_URI).isEmpty()) {
                    return ((J.Literal)l).withValue(((J.Literal)l).getValue().toString().replace("http://", "https://"));
                }
                return l;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J m = super.visitMethodInvocation(method, executionContext);
                if (!this.dataflow().findSources(INSECURE_URI).isEmpty()) {
                    // empty if block
                }
                return m;
            }
        };
    }
}

