/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.config.overlay;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.owasp.csrfguard.config.ConfigurationProvider;
import org.owasp.csrfguard.config.ConfigurationProviderFactory;
import org.owasp.csrfguard.config.PropertiesConfigurationProviderFactory;
import org.owasp.csrfguard.config.overlay.ExpirableCache;
import org.owasp.csrfguard.util.CsrfGuardUtils;

public class ConfigurationAutodetectProviderFactory
implements ConfigurationProviderFactory {
    private static ExpirableCache<Boolean, ConfigurationProvider> configurationProviderCache = new ExpirableCache(2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ConfigurationProvider retrieveConfiguration(Properties defaultProperties) {
        ConfigurationProvider configurationProvider = configurationProviderCache.get(Boolean.TRUE);
        if (configurationProvider != null) return configurationProvider;
        Class<ConfigurationAutodetectProviderFactory> clazz = ConfigurationAutodetectProviderFactory.class;
        synchronized (ConfigurationAutodetectProviderFactory.class) {
            if (configurationProvider != null) return configurationProvider;
            Class factoryClass = null;
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("Owasp.CsrfGuard.overlay.properties");
            if (inputStream != null) {
                Properties theProperties = new Properties();
                try {
                    theProperties.load(inputStream);
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Error reading config file: Owasp.CsrfGuard.overlay.properties", ioe);
                }
                CsrfGuardUtils.closeQuietly(inputStream);
                String factoryClassName = theProperties.getProperty("org.owasp.csrfguard.configuration.provider.factory");
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    if (ConfigurationAutodetectProviderFactory.class.getName().equals(factoryClassName)) {
                        throw new RuntimeException("Cannot specify auto detect factory in override file (recursion), pick the actual factory: " + factoryClassName);
                    }
                    factoryClass = CsrfGuardUtils.forName(factoryClassName);
                }
            }
            if (factoryClass == null) {
                factoryClass = PropertiesConfigurationProviderFactory.class;
            }
            ConfigurationProviderFactory factory = CsrfGuardUtils.newInstance(factoryClass);
            configurationProvider = factory.retrieveConfiguration(defaultProperties);
            configurationProviderCache.put(Boolean.TRUE, configurationProvider);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return configurationProvider;
        }
    }
}

