/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v111.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v111.audits.model.AffectedFrame;
import org.openqa.selenium.devtools.v111.audits.model.DeprecationIssueType;
import org.openqa.selenium.devtools.v111.audits.model.SourceCodeLocation;
import org.openqa.selenium.json.JsonInput;

public class DeprecationIssueDetails {
    private final Optional<AffectedFrame> affectedFrame;
    private final SourceCodeLocation sourceCodeLocation;
    private final DeprecationIssueType type;

    public DeprecationIssueDetails(Optional<AffectedFrame> affectedFrame, SourceCodeLocation sourceCodeLocation, DeprecationIssueType type) {
        this.affectedFrame = affectedFrame;
        this.sourceCodeLocation = Objects.requireNonNull(sourceCodeLocation, "sourceCodeLocation is required");
        this.type = Objects.requireNonNull(type, "type is required");
    }

    public Optional<AffectedFrame> getAffectedFrame() {
        return this.affectedFrame;
    }

    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    public DeprecationIssueType getType() {
        return this.type;
    }

    private static DeprecationIssueDetails fromJson(JsonInput input) {
        Optional<AffectedFrame> affectedFrame = Optional.empty();
        SourceCodeLocation sourceCodeLocation = null;
        DeprecationIssueType type = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "affectedFrame": {
                    affectedFrame = Optional.ofNullable((AffectedFrame)input.read(AffectedFrame.class));
                    continue block10;
                }
                case "sourceCodeLocation": {
                    sourceCodeLocation = (SourceCodeLocation)input.read(SourceCodeLocation.class);
                    continue block10;
                }
                case "type": {
                    type = (DeprecationIssueType)((Object)input.read(DeprecationIssueType.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new DeprecationIssueDetails(affectedFrame, sourceCodeLocation, type);
    }
}

