/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.XpiDriverService;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver {
    private static final Logger LOG = Logger.getLogger(FirefoxDriver.class.getName());
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(FirefoxDriver.toExecutor(options), options.toCapabilities(), options.toCapabilities());
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary) {
        this(new FirefoxOptions().setBinary(binary));
        this.warnAboutDeprecatedConstructor("FirefoxBinary", "setBinary(binary)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxOptions().setProfile(profile));
        this.warnAboutDeprecatedConstructor("FirefoxProfile", "setProfile(profile)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(new FirefoxOptions().setBinary(binary).setProfile(profile));
        this.warnAboutDeprecatedConstructor("FirefoxBinary and FirefoxProfile", "setBinary(binary).setProfile(profile)");
    }

    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(new FirefoxOptions(desiredCapabilities).addCapabilities(desiredCapabilities));
    }

    @Deprecated
    public FirefoxDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(new FirefoxOptions(desiredCapabilities).addCapabilities(desiredCapabilities).addCapabilities(requiredCapabilities));
        this.warnAboutDeprecatedConstructor("Capabilities, Capabilities", "addCapabilities(capabilities)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities capabilities) {
        this(new FirefoxOptions(capabilities).setBinary(binary).setProfile(profile).addCapabilities(capabilities));
        this.warnAboutDeprecatedConstructor("FirefoxBinary, FirefoxProfile, Capabilities", "setBinary(binary).setProfile(profile).addCapabilities(capabilities)");
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(new FirefoxOptions(desiredCapabilities).setBinary(binary).setProfile(profile).addCapabilities(desiredCapabilities).addCapabilities(requiredCapabilities));
        this.warnAboutDeprecatedConstructor("FirefoxBinary, FirefoxProfile, Capabilities", "setBinary(binary).setProfile(profile).addCapabilities(capabilities)");
    }

    private FirefoxDriver(CommandExecutor executor, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(executor, FirefoxDriver.dropCapabilities(desiredCapabilities).merge(FirefoxDriver.dropCapabilities(requiredCapabilities)));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        DriverService.Builder builder = options.isLegacy() ? XpiDriverService.builder().withBinary(options.getBinary()).withProfile(options.getProfile()) : new GeckoDriverService.Builder().usingFirefoxBinary(options.getBinary());
        return new DriverCommandExecutor(builder.build());
    }

    private void warnAboutDeprecatedConstructor(String arguments, String alternative) {
        LOG.warning(String.format("The FirefoxDriver constructor taking %s has been deprecated. Please use the FirefoxDriver(FirefoxOptions) constructor, configuring the FirefoxOptions like this: new FirefoxOptions().%s", arguments, alternative));
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        DesiredCapabilities caps;
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet toRemove = Sets.newHashSet((Object[])new String[]{BINARY, PROFILE});
            caps = new DesiredCapabilities(Maps.filterKeys((Map)capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new DesiredCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", (Object)proxy);
        }
        return caps;
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

