/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;

class CapabilitiesComparator
implements Comparator<Capabilities> {
    private final Comparator<Capabilities> compareWith;

    public CapabilitiesComparator(Capabilities desiredCapabilities, Platform currentPlatform) {
        CapabilityScorer<String> browserNameScorer = new CapabilityScorer<String>(desiredCapabilities.getBrowserName());
        Comparator<Capabilities> byBrowserName = Comparator.comparingInt(c -> browserNameScorer.score(c.getBrowserName()));
        VersionScorer versionScorer = new VersionScorer(desiredCapabilities.getVersion());
        Comparator<Capabilities> byVersion = Comparator.comparingInt(c -> versionScorer.score(c.getVersion()));
        CapabilityScorer<Boolean> jsScorer = new CapabilityScorer<Boolean>(desiredCapabilities.is("javascriptEnabled"));
        Comparator<Capabilities> byJavaScript = Comparator.comparingInt(c -> jsScorer.score(c.is("javascriptEnabled")));
        Platform desiredPlatform = desiredCapabilities.getPlatform();
        if (desiredPlatform == null) {
            desiredPlatform = Platform.ANY;
        }
        CurrentPlatformScorer currentPlatformScorer = new CurrentPlatformScorer(currentPlatform, desiredPlatform);
        Comparator<Capabilities> byCurrentPlatform = Comparator.comparingInt(c -> currentPlatformScorer.score(c.getPlatform()));
        CapabilityScorer<Platform> strictPlatformScorer = new CapabilityScorer<Platform>(desiredPlatform);
        Comparator<Capabilities> byStrictPlatform = Comparator.comparingInt(c -> strictPlatformScorer.score(c.getPlatform()));
        FuzzyPlatformScorer fuzzyPlatformScorer = new FuzzyPlatformScorer(desiredPlatform);
        Comparator<Capabilities> byFuzzyPlatform = Comparator.comparingInt(c -> fuzzyPlatformScorer.score(c.getPlatform()));
        this.compareWith = Ordering.compound(Arrays.asList(byBrowserName, byVersion, byJavaScript, byCurrentPlatform, byStrictPlatform, byFuzzyPlatform));
    }

    public static <T extends Capabilities> T getBestMatch(Capabilities against, Collection<T> toCompare) {
        return CapabilitiesComparator.getBestMatch(against, toCompare, Platform.getCurrent());
    }

    @VisibleForTesting
    static <T extends Capabilities> T getBestMatch(Capabilities against, Collection<T> toCompare, Platform currentPlatform) {
        return (T)((Capabilities)Ordering.from((Comparator)new CapabilitiesComparator(against, currentPlatform)).max(toCompare));
    }

    @Override
    public int compare(Capabilities a, Capabilities b) {
        return this.compareWith.compare(a, b);
    }

    private static boolean isNullOrAny(Platform platform) {
        return null == platform || Platform.ANY == platform;
    }

    private static class VersionScorer
    extends CapabilityScorer<String> {
        public VersionScorer(String against) {
            super(Strings.nullToEmpty((String)against).trim());
        }

        @Override
        public int score(String other) {
            if ((other = Strings.nullToEmpty((String)other).trim()).isEmpty() || ((String)this.scoreAgainst).isEmpty()) {
                return 0;
            }
            if (other.equals(this.scoreAgainst)) {
                return 1;
            }
            return -1;
        }
    }

    private static class FuzzyPlatformScorer
    extends CapabilityScorer<Platform> {
        public FuzzyPlatformScorer(Platform scoreAgainst) {
            super(scoreAgainst);
        }

        @Override
        public int score(Platform value) {
            if (CapabilitiesComparator.isNullOrAny(value)) {
                return 0;
            }
            return value.is((Platform)this.scoreAgainst) || ((Platform)this.scoreAgainst).is(value) ? 1 : -1;
        }
    }

    private static class CurrentPlatformScorer
    extends CapabilityScorer<Platform> {
        private final boolean currentIsDesired;

        private CurrentPlatformScorer(Platform currentPlatform, Platform desiredPlatform) {
            super(currentPlatform);
            this.currentIsDesired = !CapabilitiesComparator.isNullOrAny(currentPlatform) && (currentPlatform.is(desiredPlatform) || desiredPlatform.is(currentPlatform));
        }

        @Override
        public int score(Platform value) {
            if (!this.currentIsDesired || CapabilitiesComparator.isNullOrAny(value)) {
                return 0;
            }
            return ((Platform)this.scoreAgainst).is(value) || value.is((Platform)this.scoreAgainst) ? 1 : -1;
        }
    }

    private static class CapabilityScorer<T> {
        final T scoreAgainst;

        public CapabilityScorer(T scoreAgainst) {
            this.scoreAgainst = scoreAgainst;
        }

        public int score(T value) {
            if (value == null || this.scoreAgainst == null) {
                return 0;
            }
            if (value.equals(this.scoreAgainst)) {
                return 1;
            }
            return -1;
        }
    }
}

