/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.spockframework.mock.MockUtil;
import org.spockframework.spring.AbstractSpringTestExecutionListener;
import org.spockframework.spring.ScanScopedBeans;
import org.spockframework.spring.SpringTestContext;
import org.spockframework.util.ReflectionUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import spock.lang.Specification;

public class SpringMockTestExecutionListener
extends AbstractSpringTestExecutionListener {
    public static final String MOCKED_BEANS_LIST = "org.spockframework.spring.SpringMockTestExecutionListener.MOCKED_BEANS_LIST";
    private final MockUtil mockUtil = new MockUtil();

    @Override
    public void beforeTestClass(SpringTestContext testContext) throws Exception {
    }

    @Override
    public void prepareTestInstance(SpringTestContext testContext) throws Exception {
    }

    @Override
    public void beforeTestMethod(SpringTestContext testContext) throws Exception {
        ArrayList<Object> mockedBeans;
        Object testInstance = testContext.getTestInstance();
        if (testInstance instanceof Specification) {
            Specification specification = (Specification)testInstance;
            ScanScopedBeans scanScopedBeans = (ScanScopedBeans)ReflectionUtil.getAnnotationRecursive(specification.getClass(), ScanScopedBeans.class);
            HashSet<String> scopes = scanScopedBeans == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(scanScopedBeans.value()));
            ApplicationContext applicationContext = testContext.getApplicationContext();
            String[] mockBeanNames = applicationContext.getBeanDefinitionNames();
            mockedBeans = new ArrayList<Object>();
            for (String beanName : mockBeanNames) {
                Object bean;
                BeanDefinition beanDefinition = ((BeanDefinitionRegistry)applicationContext).getBeanDefinition(beanName);
                if (beanDefinition.isAbstract() || !beanDefinition.isSingleton() && !this.scanScopedBean(scanScopedBeans, scopes, beanDefinition) || !this.mockUtil.isMock(bean = applicationContext.getBean(beanName))) continue;
                this.mockUtil.attachMock(bean, specification);
                mockedBeans.add(bean);
            }
        } else {
            throw new IllegalArgumentException("SpringMockTestExecutionListener is only applicable for spock specifications.");
        }
        testContext.setAttribute(MOCKED_BEANS_LIST, mockedBeans);
    }

    private boolean scanScopedBean(ScanScopedBeans scanScopedBeans, Set<String> scopes, BeanDefinition beanDefinition) {
        return scanScopedBeans != null && (scopes.size() == 0 || scopes.contains(beanDefinition.getScope()));
    }

    @Override
    public void afterTestMethod(SpringTestContext testContext) throws Exception {
        List mockedBeans = (List)testContext.getAttribute(MOCKED_BEANS_LIST);
        if (mockedBeans != null) {
            for (Object object : mockedBeans) {
                this.mockUtil.detachMock(object);
            }
        }
    }

    @Override
    public void afterTestClass(SpringTestContext testContext) throws Exception {
    }
}

