/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.htmlunit;

import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ForwardRequestPostProcessor
implements RequestPostProcessor {
    private final String forwardedUrl;

    public ForwardRequestPostProcessor(String forwardedUrl) {
        Assert.hasText((String)forwardedUrl, (String)"Forwarded URL must not be null or empty");
        this.forwardedUrl = forwardedUrl;
    }

    @Override
    public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request2) {
        request2.setRequestURI(this.forwardedUrl);
        request2.setServletPath(this.initServletPath(request2.getContextPath()));
        return request2;
    }

    private String initServletPath(String contextPath) {
        if (StringUtils.hasText((String)contextPath)) {
            Assert.state((boolean)this.forwardedUrl.startsWith(contextPath), (String)"Forward supported to same contextPath only");
            return this.forwardedUrl.length() > contextPath.length() ? this.forwardedUrl.substring(contextPath.length()) : "";
        }
        return this.forwardedUrl;
    }
}

