/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.StringUtils;

public class SimpleInstantiationStrategy
implements InstantiationStrategy {
    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            return BeanUtils.instantiateClass(beanDefinition.getBeanClass());
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args) {
        if (beanDefinition.getMethodOverrides().isEmpty()) {
            return BeanUtils.instantiateClass(ctor, args);
        }
        return this.instantiateWithMethodInjection(beanDefinition, beanName, owner, ctor, args);
    }

    protected Object instantiateWithMethodInjection(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Constructor ctor, Object[] args) {
        throw new UnsupportedOperationException("Method Injection not supported in SimpleInstantiationStrategy");
    }

    public Object instantiate(RootBeanDefinition beanDefinition, String beanName, BeanFactory owner, Object factoryBean, Method factoryMethod, Object[] args) {
        try {
            if (!Modifier.isPublic(factoryMethod.getModifiers()) || !Modifier.isPublic(factoryMethod.getDeclaringClass().getModifiers())) {
                factoryMethod.setAccessible(true);
            }
            return factoryMethod.invoke(factoryBean, args);
        }
        catch (IllegalArgumentException ex) {
            throw new BeanDefinitionStoreException("Illegal arguments to factory method [" + factoryMethod + "]; " + "args: " + StringUtils.arrayToCommaDelimitedString(args));
        }
        catch (IllegalAccessException ex) {
            throw new BeanDefinitionStoreException("Cannot access factory method [" + factoryMethod + "]; is it public?");
        }
        catch (InvocationTargetException ex) {
            throw new BeanDefinitionStoreException("Factory method [" + factoryMethod + "] threw exception", ex.getTargetException());
        }
    }
}

