/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;

public abstract class GenericCollectionTypeResolver {
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public static Class getCollectionType(Class collectionClass) {
        return GenericCollectionTypeResolver.extractTypeFromClass(collectionClass, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0);
    }

    public static Class getMapKeyType(Class mapClass) {
        return GenericCollectionTypeResolver.extractTypeFromClass(mapClass, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0);
    }

    public static Class getMapValueType(Class mapClass) {
        return GenericCollectionTypeResolver.extractTypeFromClass(mapClass, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1);
    }

    public static Class getCollectionParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0);
    }

    public static Class getMapKeyParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0);
    }

    public static Class getMapValueParameterType(MethodParameter methodParam) {
        return GenericCollectionTypeResolver.getGenericParameterType(methodParam, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1);
    }

    public static Class getCollectionReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0, 1);
    }

    public static Class getCollectionReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection, 0, nestingLevel);
    }

    public static Class getMapKeyReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0, 1);
    }

    public static Class getMapKeyReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 0, nestingLevel);
    }

    public static Class getMapValueReturnType(Method method) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1, 1);
    }

    public static Class getMapValueReturnType(Method method, int nestingLevel) {
        return GenericCollectionTypeResolver.getGenericReturnType(method, class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map, 1, nestingLevel);
    }

    private static Class getGenericParameterType(MethodParameter methodParam, Class source, int typeIndex) {
        Assert.notNull(methodParam, "MethodParameter must not be null");
        return GenericCollectionTypeResolver.extractType(methodParam, GenericCollectionTypeResolver.getTargetType(methodParam), source, typeIndex, methodParam.getNestingLevel());
    }

    private static Type getTargetType(MethodParameter methodParam) {
        if (methodParam.getConstructor() != null) {
            return methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        if (methodParam.getParameterIndex() >= 0) {
            return methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        return methodParam.getMethod().getGenericReturnType();
    }

    private static Class getGenericReturnType(Method method, Class source, int typeIndex, int nestingLevel) {
        Assert.notNull(method, "Method must not be null");
        return GenericCollectionTypeResolver.extractType(null, method.getGenericReturnType(), source, typeIndex, nestingLevel);
    }

    private static Class extractType(MethodParameter methodParam, Type type, Class source, int typeIndex, int nestingLevel) {
        Assert.isTrue(typeIndex >= 0, "Type index must be >=1");
        Assert.isTrue(nestingLevel >= 0, "Nesting level must be >=1");
        if (type instanceof ParameterizedType) {
            return GenericCollectionTypeResolver.extractTypeFromParameterizedType(methodParam, (ParameterizedType)type, source, typeIndex, nestingLevel);
        }
        if (type instanceof Class) {
            return GenericCollectionTypeResolver.extractTypeFromClass(methodParam, (Class)type, source, typeIndex, nestingLevel);
        }
        return null;
    }

    private static Class extractTypeFromParameterizedType(MethodParameter methodParam, ParameterizedType ptype, Class source, int typeIndex, int nestingLevel) {
        Type[] lowerBounds;
        if (!(ptype.getRawType() instanceof Class)) {
            return null;
        }
        Class rawType = (Class)ptype.getRawType();
        Type[] paramTypes = ptype.getActualTypeArguments();
        if (nestingLevel > 1) {
            Integer currentTypeIndex = methodParam != null ? methodParam.getTypeIndexForLevel(nestingLevel) : null;
            int indexToUse = currentTypeIndex != null ? currentTypeIndex : paramTypes.length - 1;
            Type paramType = paramTypes[indexToUse];
            return GenericCollectionTypeResolver.extractType(methodParam, paramType, source, typeIndex, nestingLevel - 1);
        }
        if (source != null && !source.isAssignableFrom(rawType)) {
            return null;
        }
        Class fromSuperclassOrInterface = GenericCollectionTypeResolver.extractTypeFromClass(methodParam, rawType, source, typeIndex, nestingLevel);
        if (fromSuperclassOrInterface != null) {
            return fromSuperclassOrInterface;
        }
        if (paramTypes == null || typeIndex >= paramTypes.length) {
            return null;
        }
        Type paramType = paramTypes[typeIndex];
        if (paramType instanceof WildcardType && (lowerBounds = ((WildcardType)paramType).getLowerBounds()) != null && lowerBounds.length > 0) {
            paramType = lowerBounds[0];
        }
        if (paramType instanceof ParameterizedType) {
            paramType = ((ParameterizedType)paramType).getRawType();
        }
        if (paramType instanceof GenericArrayType) {
            Type compType = ((GenericArrayType)paramType).getGenericComponentType();
            if (compType instanceof Class) {
                return Array.newInstance((Class)compType, 0).getClass();
            }
        } else if (paramType instanceof Class) {
            return (Class)paramType;
        }
        return null;
    }

    private static Class extractTypeFromClass(Class clazz, Class source, int typeIndex) {
        return GenericCollectionTypeResolver.extractTypeFromClass(null, clazz, source, typeIndex, 1);
    }

    private static Class extractTypeFromClass(MethodParameter methodParam, Class clazz, Class source, int typeIndex, int nestingLevel) {
        Assert.notNull(clazz, "Class must not be null");
        if (clazz.getSuperclass() != null && GenericCollectionTypeResolver.isIntrospectionCandidate(clazz.getSuperclass())) {
            return GenericCollectionTypeResolver.extractType(methodParam, clazz.getGenericSuperclass(), source, typeIndex, nestingLevel);
        }
        Type[] ifcs = clazz.getGenericInterfaces();
        if (ifcs != null) {
            for (int i = 0; i < ifcs.length; ++i) {
                Type ifc;
                Type rawType = ifc = ifcs[i];
                if (ifc instanceof ParameterizedType) {
                    rawType = ((ParameterizedType)ifc).getRawType();
                }
                if (!(rawType instanceof Class) || !GenericCollectionTypeResolver.isIntrospectionCandidate((Class)rawType)) continue;
                return GenericCollectionTypeResolver.extractType(methodParam, ifc, source, typeIndex, nestingLevel);
            }
        }
        return null;
    }

    private static boolean isIntrospectionCandidate(Class clazz) {
        return (class$java$util$Collection == null ? (class$java$util$Collection = GenericCollectionTypeResolver.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(clazz) || (class$java$util$Map == null ? (class$java$util$Map = GenericCollectionTypeResolver.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

