/*
 * Decompiled with CFR 0.152.
 */
package org.vibur.objectpool.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.vibur.objectpool.BasePool;
import org.vibur.objectpool.util.ArgumentValidation;
import org.vibur.objectpool.util.ThreadedPoolReducer;

public class SamplingPoolReducer
implements ThreadedPoolReducer {
    private final BasePool pool;
    private final long sleepNanoTime;
    private final int samples;
    private final Thread reducerThread;
    protected static final double MAX_REDUCTION_FRACTION = 0.2;
    protected int minRemainingCreated;

    public SamplingPoolReducer(BasePool pool, long timeInterval, TimeUnit unit, int samples) {
        ArgumentValidation.forbidIllegalArgument(timeInterval <= 0L);
        ArgumentValidation.forbidIllegalArgument(samples <= 0);
        this.sleepNanoTime = unit.toNanos(timeInterval) / (long)samples;
        ArgumentValidation.forbidIllegalArgument(this.sleepNanoTime == 0L);
        this.pool = Objects.requireNonNull(pool);
        this.samples = samples;
        this.reducerThread = new Thread(new PoolReducerRunnable());
    }

    @Override
    public void start() {
        this.reducerThread.setName(this.getThreadName());
        this.reducerThread.setDaemon(true);
        this.reducerThread.setPriority(8);
        this.reducerThread.start();
    }

    protected String getThreadName() {
        return this.reducerThread.getName();
    }

    protected void samplePool() {
        int remainingCreated = this.pool.remainingCreated();
        this.minRemainingCreated = Math.min(this.minRemainingCreated, remainingCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reducePool() {
        int reduction = this.calculateReduction();
        int reduced = -1;
        Throwable thrown = null;
        try {
            reduced = this.pool.reduceCreatedBy(reduction, false);
        }
        catch (Throwable t) {
            thrown = t;
        }
        finally {
            this.afterReduce(reduction, reduced, thrown);
        }
    }

    protected int calculateReduction() {
        int createdTotal = this.pool.createdTotal();
        int maxReduction = (int)Math.ceil((double)createdTotal * 0.2);
        int reduction = Math.min(this.minRemainingCreated, maxReduction);
        int bottomThreshold = createdTotal - this.pool.initialSize();
        reduction = Math.min(reduction, bottomThreshold);
        return Math.max(reduction, 0);
    }

    protected void afterReduce(int reduction, int reduced, Throwable thrown) {
        if (thrown != null) {
            this.terminate();
        }
    }

    @Override
    public Thread.State getState() {
        return this.reducerThread.getState();
    }

    @Override
    public void terminate() {
        this.reducerThread.interrupt();
    }

    private class PoolReducerRunnable
    implements Runnable {
        private PoolReducerRunnable() {
        }

        @Override
        public void run() {
            int sample = 1;
            SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
            try {
                while (true) {
                    TimeUnit.NANOSECONDS.sleep(SamplingPoolReducer.this.sleepNanoTime);
                    SamplingPoolReducer.this.samplePool();
                    if (sample++ % SamplingPoolReducer.this.samples != 0) continue;
                    SamplingPoolReducer.this.reducePool();
                    sample = 1;
                    SamplingPoolReducer.this.minRemainingCreated = Integer.MAX_VALUE;
                }
            }
            catch (InterruptedException ignored) {
                return;
            }
        }
    }
}

