/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.groovy.ldap;

import groovy.lang.Closure;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.xbib.groovy.ldap.ModificationType;
import org.xbib.groovy.ldap.Search;
import org.xbib.groovy.ldap.SearchScope;
import org.xbib.groovy.ldap.WithContext;

public class LDAP {
    private static final Logger logger = Logger.getLogger(LDAP.class.getName());
    private static final String DEFAULT_URL = "ldap://localhost:389/";
    private final String url;
    private final String bindUser;
    private final String bindPassword;

    private LDAP(String url, String bindUser, String bindPassword) {
        this.url = url;
        this.bindUser = bindUser;
        this.bindPassword = bindPassword;
    }

    public static LDAP newInstance() {
        return new LDAP(DEFAULT_URL, null, null);
    }

    public static LDAP newInstance(String url) {
        return new LDAP(url, null, null);
    }

    public static LDAP newInstance(String url, String bindUser, String bindPassword) {
        return new LDAP(url, bindUser, bindPassword);
    }

    public void add(String dn, Map<String, Object> attributes) throws NamingException {
        WithContext<Object> action = ctx -> {
            BasicAttributes attrs = new BasicAttributes();
            for (Map.Entry entry : attributes.entrySet()) {
                logger.log(Level.FINE, MessageFormat.format("entry {0} {1}", entry, entry.getValue().getClass()));
                Attribute attr = LDAP.createAttribute((String)entry.getKey(), entry.getValue());
                logger.log(Level.FINE, MessageFormat.format("attr {0} {1}", attr, attr.get().getClass()));
                attrs.put(attr);
            }
            ctx.createSubcontext(dn, (Attributes)attrs);
            return null;
        };
        this.performWithContext(action);
    }

    public void delete(String dn) throws NamingException {
        if (!this.exists(dn).booleanValue()) {
            throw new NameNotFoundException("Entry " + dn + " does not exist!");
        }
        WithContext<Object> action = ctx -> {
            ctx.destroySubcontext(dn);
            return null;
        };
        this.performWithContext(action);
    }

    public Object read(String dn) throws NamingException {
        return this.performWithContext(ctx -> ctx.lookup(dn));
    }

    public Boolean exists(String dn) throws NamingException {
        WithContext<Boolean> action = ctx -> {
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(0);
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setReturningObjFlag(false);
            try {
                ctx.search(dn, "(objectClass=*)", searchControls);
                return true;
            }
            catch (NameNotFoundException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
                return false;
            }
        };
        return this.performWithContext(action);
    }

    public boolean compare(String dn, Map<String, Object> assertion) throws NamingException {
        if (assertion.size() != 1) {
            throw new IllegalArgumentException("Assertion may only include one attribute");
        }
        WithContext<Boolean> action = ctx -> {
            SearchControls searchControls = new SearchControls();
            searchControls.setReturningAttributes(new String[0]);
            searchControls.setSearchScope(0);
            searchControls.setReturningObjFlag(false);
            String attrName = (String)assertion.keySet().iterator().next();
            String filter = "(" + attrName + "={0})";
            Object value = assertion.get(attrName);
            NamingEnumeration<SearchResult> enumeration = ctx.search(dn, filter, new Object[]{value}, searchControls);
            return enumeration.hasMore();
        };
        return this.performWithContext(action);
    }

    public void modifyDn(String dn, String newRDN, boolean deleteOldRDN, String newSuperior) throws NamingException {
        WithContext<Object> action = ctx -> {
            LdapName source = new LdapName(dn);
            LdapName target = new LdapName(newSuperior);
            target.add(newRDN);
            ctx.addToEnvironment("java.naming.ldap.deleteRDN", Boolean.toString(deleteOldRDN));
            ctx.rename(source, target);
            return null;
        };
        this.performWithContext(action);
    }

    public void eachEntry(String filter, String base, SearchScope scope, Closure closure) throws NamingException {
        this.eachEntry(new Search(base, scope, filter), closure);
    }

    public void eachEntry(Map<String, Object> searchParams, Closure closure) throws NamingException {
        this.eachEntry(new Search(searchParams), closure);
    }

    public void eachEntry(String filter, Closure closure) throws NamingException {
        this.eachEntry(filter, "", SearchScope.SUB, closure);
    }

    public void eachEntry(Search search, Closure closure) throws NamingException {
        WithContext<Object> action = ctx -> {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(search.getScope().getValue());
            ctls.setReturningAttributes(search.getAttrs());
            ctls.setReturningObjFlag(true);
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), search.getFilter(), search.getFilterArgs(), ctls);
            while (results != null && results.hasMore()) {
                SearchResult sr = results.next();
                String dn = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                NamingEnumeration<? extends Attribute> en = attrs.getAll();
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("dn", dn);
                while (en.hasMore()) {
                    Attribute attr = en.next();
                    String key = attr.getID();
                    map.put(key, attr.get(0).toString());
                }
                closure.call(map);
            }
            return null;
        };
        this.performWithContext(action);
    }

    public void modify(String dn, String modType, Map<String, Object> attributes) throws NamingException {
        this.modify(dn, ModificationType.valueOf(modType), attributes);
    }

    public void modify(String dn, ModificationType modType, Map<String, Object> attributes) throws NamingException {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        for (String key : attributes.keySet()) {
            Attribute attr = LDAP.createAttribute(key, attributes.get(key));
            ModificationItem item = new ModificationItem(modType.getValue(), attr);
            mods.add(item);
        }
        ModificationItem[] modItems = mods.toArray(new ModificationItem[mods.size()]);
        WithContext<Object> action = ctx -> {
            ctx.modifyAttributes(dn, modItems);
            return null;
        };
        this.performWithContext(action);
    }

    public void modify(String dn, List<List> modificationItem) throws NamingException {
        ArrayList<ModificationItem> mods = new ArrayList<ModificationItem>();
        for (List pair : modificationItem) {
            ModificationType modType;
            if (pair.size() != 2) {
                throw new IllegalArgumentException("parameter 2 is not a list of pairs");
            }
            Object oModType = pair.get(0);
            if (oModType instanceof ModificationType) {
                modType = (ModificationType)((Object)oModType);
            } else if (oModType instanceof String) {
                modType = ModificationType.valueOf((String)oModType);
            } else {
                throw new IllegalArgumentException("parameter is not o valid ModificationType: " + oModType);
            }
            if (!(pair.get(1) instanceof Map)) continue;
            Map attributes = (Map)pair.get(1);
            for (String key : attributes.keySet()) {
                Attribute attr = LDAP.createAttribute(key, attributes.get(key));
                ModificationItem item = new ModificationItem(modType.getValue(), attr);
                mods.add(item);
            }
        }
        ModificationItem[] modItems = mods.toArray(new ModificationItem[mods.size()]);
        WithContext<Object> action = ctx -> {
            ctx.modifyAttributes(dn, modItems);
            return null;
        };
        this.performWithContext(action);
    }

    public List<Map<String, Object>> search(String filter) throws NamingException {
        return this.search(new Search("", SearchScope.SUB, filter));
    }

    public List<Map<String, Object>> search(String base, SearchScope scope, String filter) throws NamingException {
        return this.search(new Search(base, scope, filter));
    }

    public List<Map<String, Object>> search(Map<String, Object> searchParams) throws NamingException {
        return this.search(new Search(searchParams));
    }

    public List<Map<String, Object>> search(Search search) throws NamingException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        WithContext<Object> action = ctx -> {
            NamingEnumeration<SearchResult> results = ctx.search(search.getBase(), search.getFilter(), search.getFilterArgs(), search.getSearchControls());
            while (results != null && results.hasMore()) {
                SearchResult sr = results.next();
                String dn = sr.getNameInNamespace();
                Attributes attrs = sr.getAttributes();
                NamingEnumeration<? extends Attribute> en = attrs.getAll();
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put("dn", dn);
                while (en.hasMore()) {
                    Attribute attr = en.next();
                    String key = attr.getID();
                    if (attr.size() == 1) {
                        map.put(key, attr.get());
                        continue;
                    }
                    ArrayList<Object> l = new ArrayList<Object>();
                    for (int i = 0; i < attr.size(); ++i) {
                        l.add(attr.get(i));
                    }
                    map.put(key, l);
                }
                result.add(map);
            }
            return null;
        };
        this.performWithContext(action);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String bindUser, String bindPassword) throws NamingException {
        Context ctx = null;
        try {
            ctx = new InitialLdapContext(LDAP.createEnvironment(this.url, bindUser, bindPassword), null);
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T performWithContext(WithContext<T> action) throws NamingException {
        Context ctx = null;
        try {
            if (this.url != null) {
                ctx = new InitialLdapContext(LDAP.createEnvironment(this.url, this.bindUser, this.bindPassword), null);
                T t = action.perform((LdapContext)ctx);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (NamingException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
            }
        }
    }

    private static Properties createEnvironment(String url, String bindUser, String bindPassword) {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.setProperty("java.naming.provider.url", url);
        if (bindUser != null) {
            env.setProperty("java.naming.security.principal", bindUser);
            env.setProperty("java.naming.security.credentials", bindPassword);
        }
        return env;
    }

    private static Attribute createAttribute(String name, Object value) {
        BasicAttribute attr = new BasicAttribute(name);
        if (value instanceof Collection) {
            Collection values = (Collection)value;
            for (Object val : values) {
                attr.add(val);
            }
        } else {
            attr.add(value);
        }
        return attr;
    }

    public static String escapeValue(String filter) {
        StringBuilder sb = new StringBuilder();
        block12: for (int i = 0; i < filter.length(); ++i) {
            switch (filter.charAt(i)) {
                case '\\': {
                    sb.append("\\5c");
                    continue block12;
                }
                case '!': {
                    sb.append("\\21");
                    continue block12;
                }
                case '&': {
                    sb.append("\\26");
                    continue block12;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block12;
                }
                case ':': {
                    sb.append("\\3a");
                    continue block12;
                }
                case '(': {
                    sb.append("\\28");
                    continue block12;
                }
                case ')': {
                    sb.append("\\29");
                    continue block12;
                }
                case '|': {
                    sb.append("\\7c");
                    continue block12;
                }
                case '~': {
                    sb.append("\\7e");
                    continue block12;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block12;
                }
                default: {
                    sb.append(filter.charAt(i));
                }
            }
        }
        return sb.toString();
    }
}

