/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.groovy.ldap;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import javax.naming.directory.SearchControls;
import org.xbib.groovy.ldap.SearchScope;

public class Search {
    public static final int DEFAULT_TIME_LIMIT = 5000;
    public static final int DEFAULT_COUNT_LIMIT = 20000;
    private final SearchControls searchControls;
    private final String base;
    private final SearchScope scope;
    private final String filter;
    private final Object[] filterArgs;
    private final String[] attrs;
    private int timeLimit;
    private int countLimit;

    public Search() {
        this("", SearchScope.SUB, "(objectClass=*)", 5000, 20000);
    }

    public Search(String base, SearchScope scope, String filter) {
        this(base, scope, filter, 5000, 20000);
    }

    public Search(String base, SearchScope scope, String filter, int timeLimit, int countLimit) {
        this.base = base;
        this.scope = scope;
        this.filter = filter;
        this.filterArgs = null;
        this.attrs = null;
        this.timeLimit = timeLimit;
        this.countLimit = countLimit;
        this.searchControls = Search.getSearchControls(scope, null, timeLimit, countLimit);
    }

    public Search(Map<String, Object> map) {
        this.base = map.containsKey("base") ? map.get("base").toString() : "";
        this.scope = map.containsKey("scope") ? SearchScope.valueOf(map.get("scope").toString()) : SearchScope.SUB;
        this.filter = map.containsKey("filter") ? map.get("filter").toString() : "(objectClass=*)";
        this.filterArgs = map.containsKey("filterArgs") ? Search.toArray(Object.class, map.get("filterArgs")) : null;
        this.attrs = map.containsKey("attrs") ? Search.toArray(String.class, map.get("attrs")) : null;
        this.timeLimit = map.containsKey("timeLimit") ? Integer.parseInt((String)map.get("timeLimit")) : 5000;
        this.countLimit = map.containsKey("countLimit") ? Integer.parseInt((String)map.get("countLimit")) : 20000;
        this.searchControls = Search.getSearchControls(this.scope, this.attrs, this.timeLimit, this.countLimit);
    }

    private static <T> T[] toArray(Class<T> target, Object value) {
        Object[] values = null;
        if (value.getClass().isArray()) {
            values = (Object[])value;
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            values = c.toArray((Object[])Array.newInstance(target, c.size()));
        } else {
            values = (Object[])Array.newInstance(target, 1);
            values[0] = value;
        }
        return values;
    }

    public String[] getAttrs() {
        return this.attrs;
    }

    public String getBase() {
        return this.base;
    }

    public String getFilter() {
        return this.filter;
    }

    public Object[] getFilterArgs() {
        return this.filterArgs;
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public SearchControls getSearchControls() {
        return this.searchControls;
    }

    private static SearchControls getSearchControls(SearchScope searchScope, String[] attrs, int timeLimit, int countLimit) {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(searchScope.getValue());
        searchControls.setReturningAttributes(attrs);
        searchControls.setReturningObjFlag(true);
        searchControls.setTimeLimit(timeLimit);
        searchControls.setCountLimit(countLimit);
        return searchControls;
    }
}

