/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.eventstream;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.eventstream.Header;
import software.amazon.awssdk.crt.eventstream.MessageType;
import software.amazon.awssdk.crt.eventstream.ServerConnectionContinuation;

public abstract class ServerConnectionContinuationHandler
implements AutoCloseable {
    protected ServerConnectionContinuation continuation;
    private CompletableFuture<Void> completableFuture = new CompletableFuture();

    protected ServerConnectionContinuationHandler(ServerConnectionContinuation continuation) {
        this.continuation = continuation;
    }

    protected void onContinuationClosed() {
        this.close();
    }

    protected abstract void onContinuationMessage(List<Header> var1, byte[] var2, MessageType var3, int var4);

    void onContinuationMessageShim(byte[] headersPayload, byte[] payload, int messageType, int messageFlags) {
        ArrayList<Header> headers = new ArrayList<Header>();
        ByteBuffer headersBuffer = ByteBuffer.wrap(headersPayload);
        while (headersBuffer.hasRemaining()) {
            Header header = Header.fromByteBuffer(headersBuffer);
            headers.add(header);
        }
        this.onContinuationMessage(headers, payload, MessageType.fromEnumValue(messageType), messageFlags);
    }

    void onContinuationClosedShim() {
        this.onContinuationClosed();
        this.completableFuture.complete(null);
    }

    public CompletableFuture<Void> getContinuationClosedFuture() {
        return this.completableFuture;
    }

    @Override
    public void close() {
        if (this.continuation != null) {
            this.continuation.decRef("close() called");
            this.continuation = null;
        }
    }
}

