/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkInternalApi
public class ConfiguredS3SdkHttpRequest
implements ToCopyableBuilder<Builder, ConfiguredS3SdkHttpRequest> {
    private final SdkHttpRequest sdkHttpRequest;
    private final Region signingRegionModification;

    private ConfiguredS3SdkHttpRequest(Builder builder) {
        this.sdkHttpRequest = (SdkHttpRequest)Validate.notNull((Object)builder.sdkHttpRequest, (String)"sdkHttpRequest", (Object[])new Object[0]);
        this.signingRegionModification = builder.signingRegionModification;
    }

    public static Builder builder() {
        return new Builder();
    }

    public SdkHttpRequest sdkHttpRequest() {
        return this.sdkHttpRequest;
    }

    public Optional<Region> signingRegionModification() {
        return Optional.ofNullable(this.signingRegionModification);
    }

    public Builder toBuilder() {
        return ConfiguredS3SdkHttpRequest.builder().sdkHttpRequest(this.sdkHttpRequest).signingRegionModification(this.signingRegionModification);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfiguredS3SdkHttpRequest that = (ConfiguredS3SdkHttpRequest)o;
        if (this.sdkHttpRequest != null ? !this.sdkHttpRequest.equals(that.sdkHttpRequest) : that.sdkHttpRequest != null) {
            return false;
        }
        return this.signingRegionModification != null ? this.signingRegionModification.equals(that.signingRegionModification) : that.signingRegionModification == null;
    }

    public int hashCode() {
        int result = this.sdkHttpRequest != null ? this.sdkHttpRequest.hashCode() : 0;
        result = 31 * result + (this.signingRegionModification != null ? this.signingRegionModification.hashCode() : 0);
        return result;
    }

    public static class Builder
    implements CopyableBuilder<Builder, ConfiguredS3SdkHttpRequest> {
        private SdkHttpRequest sdkHttpRequest;
        private Region signingRegionModification;

        private Builder() {
        }

        public Builder sdkHttpRequest(SdkHttpRequest sdkHttpRequest) {
            this.sdkHttpRequest = sdkHttpRequest;
            return this;
        }

        public Builder signingRegionModification(Region signingRegionModification) {
            this.signingRegionModification = signingRegionModification;
            return this;
        }

        public ConfiguredS3SdkHttpRequest build() {
            return new ConfiguredS3SdkHttpRequest(this);
        }
    }
}

