/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Permission {
    FULL_CONTROL("FULL_CONTROL"),
    WRITE("WRITE"),
    WRITE_ACP("WRITE_ACP"),
    READ("READ"),
    READ_ACP("READ_ACP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Permission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Permission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Permission.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Permission> knownValues() {
        return Stream.of(Permission.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

