/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointParams;
import software.amazon.awssdk.services.s3.endpoints.S3EndpointProvider;
import software.amazon.awssdk.services.s3.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.s3.endpoints.internal.Condition;
import software.amazon.awssdk.services.s3.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.s3.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.s3.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.s3.endpoints.internal.Expr;
import software.amazon.awssdk.services.s3.endpoints.internal.FnNode;
import software.amazon.awssdk.services.s3.endpoints.internal.Identifier;
import software.amazon.awssdk.services.s3.endpoints.internal.Literal;
import software.amazon.awssdk.services.s3.endpoints.internal.Parameter;
import software.amazon.awssdk.services.s3.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.s3.endpoints.internal.Parameters;
import software.amazon.awssdk.services.s3.endpoints.internal.Rule;
import software.amazon.awssdk.services.s3.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultS3EndpointProvider
implements S3EndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultS3EndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(S3EndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultS3EndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(S3EndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.bucket() != null) {
            paramsMap.put(Identifier.of("Bucket"), Value.fromStr(params.bucket()));
        }
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        if (params.forcePathStyle() != null) {
            paramsMap.put(Identifier.of("ForcePathStyle"), Value.fromBool(params.forcePathStyle()));
        }
        if (params.accelerate() != null) {
            paramsMap.put(Identifier.of("Accelerate"), Value.fromBool(params.accelerate()));
        }
        if (params.useGlobalEndpoint() != null) {
            paramsMap.put(Identifier.of("UseGlobalEndpoint"), Value.fromBool(params.useGlobalEndpoint()));
        }
        if (params.useObjectLambdaEndpoint() != null) {
            paramsMap.put(Identifier.of("UseObjectLambdaEndpoint"), Value.fromBool(params.useObjectLambdaEndpoint()));
        }
        if (params.disableAccessPoints() != null) {
            paramsMap.put(Identifier.of("DisableAccessPoints"), Value.fromBool(params.disableAccessPoints()));
        }
        if (params.disableMultiRegionAccessPoints() != null) {
            paramsMap.put(Identifier.of("DisableMultiRegionAccessPoints"), Value.fromBool(params.disableMultiRegionAccessPoints()));
        }
        if (params.useArnRegion() != null) {
            paramsMap.put(Identifier.of("UseArnRegion"), Value.fromBool(params.useArnRegion()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).error("Expected a endpoint to be specified but no endpoint was found");
    }

    private static Rule endpointRule_9() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.ec2.{url#authority}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("regionPrefix")), Expr.of("beta"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_8(), DefaultS3EndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.ec2.s3-outposts.{Region}.{regionPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("hardwareType")), Expr.of("e"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_7(), DefaultS3EndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).error("Expected a endpoint to be specified but no endpoint was found");
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.op-{outpostId}.{url#authority}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_12() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("regionPrefix")), Expr.of("beta"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_13(), DefaultS3EndpointProvider.endpointRule_14()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.op-{outpostId}.s3-outposts.{Region}.{regionPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_11() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("hardwareType")), Expr.of("o"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_12(), DefaultS3EndpointProvider.endpointRule_15()));
    }

    private static Rule endpointRule_16() {
        return Rule.builder().error("Unrecognized hardware type: \"Expected hardware type o or e but got {hardwareType}\"");
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_6(), DefaultS3EndpointProvider.endpointRule_11(), DefaultS3EndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("outpostId")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_17() {
        return Rule.builder().error("Invalid ARN: The outpost Id must only contain a-z, A-Z, 0-9 and `-`.");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("substring").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(49), Expr.of(50), Expr.of(true))).build().validate()).result("hardwareType").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("substring").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(8), Expr.of(12), Expr.of(true))).build().validate()).result("regionPrefix").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("substring").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(0), Expr.of(7), Expr.of(true))).build().validate()).result("abbaSuffix").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("substring").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(32), Expr.of(49), Expr.of(true))).build().validate()).result("outpostId").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("regionPartition").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("abbaSuffix")), Expr.of("--op-s3"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_4(), DefaultS3EndpointProvider.endpointRule_17()));
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate())).build().validate()).build()).error("Custom endpoint `{Endpoint}` was not a valid URI");
    }

    private static Rule endpointRule_23() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).build()).error("Path-style addressing cannot be used with ARN buckets");
    }

    private static Rule endpointRule_25() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).error("Cannot set dual-stack in combination with a custom endpoint.");
    }

    private static Rule endpointRule_31() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_32() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_34() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_33() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_34()));
    }

    private static Rule endpointRule_35() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_36() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_37() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_39() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_38() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_39()));
    }

    private static Rule endpointRule_40() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_41() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_42() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_44() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_43() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_44()));
    }

    private static Rule endpointRule_45() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_46() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_47() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_49() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_48() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_49()));
    }

    private static Rule endpointRule_50() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_51() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_52() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_54() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_55() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_53() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_54(), DefaultS3EndpointProvider.endpointRule_55()));
    }

    private static Rule endpointRule_56() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_57() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_58() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_60() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_61() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_59() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_60(), DefaultS3EndpointProvider.endpointRule_61()));
    }

    private static Rule endpointRule_62() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_30() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_31(), DefaultS3EndpointProvider.endpointRule_32(), DefaultS3EndpointProvider.endpointRule_33(), DefaultS3EndpointProvider.endpointRule_35(), DefaultS3EndpointProvider.endpointRule_36(), DefaultS3EndpointProvider.endpointRule_37(), DefaultS3EndpointProvider.endpointRule_38(), DefaultS3EndpointProvider.endpointRule_40(), DefaultS3EndpointProvider.endpointRule_41(), DefaultS3EndpointProvider.endpointRule_42(), DefaultS3EndpointProvider.endpointRule_43(), DefaultS3EndpointProvider.endpointRule_45(), DefaultS3EndpointProvider.endpointRule_46(), DefaultS3EndpointProvider.endpointRule_47(), DefaultS3EndpointProvider.endpointRule_48(), DefaultS3EndpointProvider.endpointRule_50(), DefaultS3EndpointProvider.endpointRule_51(), DefaultS3EndpointProvider.endpointRule_52(), DefaultS3EndpointProvider.endpointRule_53(), DefaultS3EndpointProvider.endpointRule_56(), DefaultS3EndpointProvider.endpointRule_57(), DefaultS3EndpointProvider.endpointRule_58(), DefaultS3EndpointProvider.endpointRule_59(), DefaultS3EndpointProvider.endpointRule_62()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_30()));
    }

    private static Rule endpointRule_63() {
        return Rule.builder().error("Path-style addressing cannot be used with S3 Accelerate");
    }

    private static Rule endpointRule_28() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_29(), DefaultS3EndpointProvider.endpointRule_63()));
    }

    private static Rule endpointRule_27() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_64() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_26() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_27(), DefaultS3EndpointProvider.endpointRule_64()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("uriEncode").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).result("uri_encoded_bucket").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_25(), DefaultS3EndpointProvider.endpointRule_26()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_23(), DefaultS3EndpointProvider.endpointRule_24()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("ForcePathStyle")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("ForcePathStyle")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_70() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_72() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Accelerate cannot be used with FIPS");
    }

    private static Rule endpointRule_74() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("S3 Accelerate cannot be used in this region");
    }

    private static Rule endpointRule_76() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Host override cannot be combined with Dualstack, FIPS, or S3 Accelerate");
    }

    private static Rule endpointRule_78() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Host override cannot be combined with Dualstack, FIPS, or S3 Accelerate");
    }

    private static Rule endpointRule_80() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("Host override cannot be combined with Dualstack, FIPS, or S3 Accelerate");
    }

    private static Rule endpointRule_82() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_83() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_85() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_84() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_85()));
    }

    private static Rule endpointRule_86() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_87() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_88() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_90() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_89() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_90()));
    }

    private static Rule endpointRule_91() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_92() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_93() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_95() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.dualstack.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_94() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_95()));
    }

    private static Rule endpointRule_96() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.dualstack.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_97() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_98() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_100() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_99() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_100()));
    }

    private static Rule endpointRule_101() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_102() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{Bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_103() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_104() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{Bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_105() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_107() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{Bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_108() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{Bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_106() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_107(), DefaultS3EndpointProvider.endpointRule_108()));
    }

    private static Rule endpointRule_110() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_111() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_109() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_110(), DefaultS3EndpointProvider.endpointRule_111()));
    }

    private static Rule endpointRule_112() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{Bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_113() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("isIp"))).build().validate(), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_114() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_115() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_117() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_118() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_116() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_117(), DefaultS3EndpointProvider.endpointRule_118()));
    }

    private static Rule endpointRule_119() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3-accelerate.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_120() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_121() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_123() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_124() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_122() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_123(), DefaultS3EndpointProvider.endpointRule_124()));
    }

    private static Rule endpointRule_125() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{Bucket}.s3.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_81() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_82(), DefaultS3EndpointProvider.endpointRule_83(), DefaultS3EndpointProvider.endpointRule_84(), DefaultS3EndpointProvider.endpointRule_86(), DefaultS3EndpointProvider.endpointRule_87(), DefaultS3EndpointProvider.endpointRule_88(), DefaultS3EndpointProvider.endpointRule_89(), DefaultS3EndpointProvider.endpointRule_91(), DefaultS3EndpointProvider.endpointRule_92(), DefaultS3EndpointProvider.endpointRule_93(), DefaultS3EndpointProvider.endpointRule_94(), DefaultS3EndpointProvider.endpointRule_96(), DefaultS3EndpointProvider.endpointRule_97(), DefaultS3EndpointProvider.endpointRule_98(), DefaultS3EndpointProvider.endpointRule_99(), DefaultS3EndpointProvider.endpointRule_101(), DefaultS3EndpointProvider.endpointRule_102(), DefaultS3EndpointProvider.endpointRule_103(), DefaultS3EndpointProvider.endpointRule_104(), DefaultS3EndpointProvider.endpointRule_105(), DefaultS3EndpointProvider.endpointRule_106(), DefaultS3EndpointProvider.endpointRule_109(), DefaultS3EndpointProvider.endpointRule_112(), DefaultS3EndpointProvider.endpointRule_113(), DefaultS3EndpointProvider.endpointRule_114(), DefaultS3EndpointProvider.endpointRule_115(), DefaultS3EndpointProvider.endpointRule_116(), DefaultS3EndpointProvider.endpointRule_119(), DefaultS3EndpointProvider.endpointRule_120(), DefaultS3EndpointProvider.endpointRule_121(), DefaultS3EndpointProvider.endpointRule_122(), DefaultS3EndpointProvider.endpointRule_125()));
    }

    private static Rule endpointRule_79() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_80(), DefaultS3EndpointProvider.endpointRule_81()));
    }

    private static Rule endpointRule_77() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_78(), DefaultS3EndpointProvider.endpointRule_79()));
    }

    private static Rule endpointRule_75() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_76(), DefaultS3EndpointProvider.endpointRule_77()));
    }

    private static Rule endpointRule_73() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_74(), DefaultS3EndpointProvider.endpointRule_75()));
    }

    private static Rule endpointRule_71() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_72(), DefaultS3EndpointProvider.endpointRule_73()));
    }

    private static Rule endpointRule_69() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_70(), DefaultS3EndpointProvider.endpointRule_71()));
    }

    private static Rule endpointRule_68() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_69()));
    }

    private static Rule endpointRule_126() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_67() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_68(), DefaultS3EndpointProvider.endpointRule_126()));
    }

    private static Rule endpointRule_66() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_67()));
    }

    private static Rule endpointRule_127() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_65() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.isVirtualHostableS3Bucket").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_66(), DefaultS3EndpointProvider.endpointRule_127()));
    }

    private static Rule endpointRule_132() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{Bucket}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_131() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_132()));
    }

    private static Rule endpointRule_133() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_130() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_131(), DefaultS3EndpointProvider.endpointRule_133()));
    }

    private static Rule endpointRule_129() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_130()));
    }

    private static Rule endpointRule_134() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_128() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("url")), Expr.of("scheme"))).build().validate(), Expr.of("http"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("aws.isVirtualHostableS3Bucket").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_129(), DefaultS3EndpointProvider.endpointRule_134()));
    }

    private static Rule endpointRule_143() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("S3 Object Lambda does not support Dual-stack");
    }

    private static Rule endpointRule_145() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("S3 Object Lambda does not support S3 Accelerate");
    }

    private static Rule endpointRule_149() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("DisableAccessPoints")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("DisableAccessPoints")), Expr.of(true))).build().validate()).build()).error("Access points are not supported for this operation");
    }

    private static Rule endpointRule_153() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of("{Region}"))).build().validate())).build().validate()).build()).error("Invalid configuration: region from ARN `{bucketArn#region}` does not match client region `{Region}` and UseArnRegion is `false`");
    }

    private static Rule endpointRule_163() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(""))).build().validate()).build()).error("Invalid ARN: Missing account id");
    }

    private static Rule endpointRule_169() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketPartition")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_171() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{accessPointName}-{bucketArn#accountId}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_172() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-object-lambda-fips.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_173() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-object-lambda.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_170() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_171(), DefaultS3EndpointProvider.endpointRule_172(), DefaultS3EndpointProvider.endpointRule_173()));
    }

    private static Rule endpointRule_168() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_169(), DefaultS3EndpointProvider.endpointRule_170()));
    }

    private static Rule endpointRule_167() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointName")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_168()));
    }

    private static Rule endpointRule_174() {
        return Rule.builder().error("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `{accessPointName}`");
    }

    private static Rule endpointRule_166() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_167(), DefaultS3EndpointProvider.endpointRule_174()));
    }

    private static Rule endpointRule_165() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_166()));
    }

    private static Rule endpointRule_175() {
        return Rule.builder().error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `{bucketArn#accountId}`");
    }

    private static Rule endpointRule_164() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_165(), DefaultS3EndpointProvider.endpointRule_175()));
    }

    private static Rule endpointRule_162() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_163(), DefaultS3EndpointProvider.endpointRule_164()));
    }

    private static Rule endpointRule_161() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_162()));
    }

    private static Rule endpointRule_176() {
        return Rule.builder().error("Invalid region in ARN: `{bucketArn#region}` (invalid DNS name)");
    }

    private static Rule endpointRule_160() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_161(), DefaultS3EndpointProvider.endpointRule_176()));
    }

    private static Rule endpointRule_159() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketPartition")), Expr.of("name"))).build().validate(), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_160()));
    }

    private static Rule endpointRule_177() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but ARN (`{Bucket}`) has `{bucketPartition#name}`");
    }

    private static Rule endpointRule_158() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_159(), DefaultS3EndpointProvider.endpointRule_177()));
    }

    private static Rule endpointRule_157() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_158()));
    }

    private static Rule endpointRule_178() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_156() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_157(), DefaultS3EndpointProvider.endpointRule_178()));
    }

    private static Rule endpointRule_155() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate())).build().validate()).result("bucketPartition").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_156()));
    }

    private static Rule endpointRule_179() {
        return Rule.builder().error("Could not load partition for ARN region `{bucketArn#region}`");
    }

    private static Rule endpointRule_154() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_155(), DefaultS3EndpointProvider.endpointRule_179()));
    }

    private static Rule endpointRule_152() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_153(), DefaultS3EndpointProvider.endpointRule_154()));
    }

    private static Rule endpointRule_151() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[2]"))).build().validate())).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_152()));
    }

    private static Rule endpointRule_180() {
        return Rule.builder().error("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.");
    }

    private static Rule endpointRule_150() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_151(), DefaultS3EndpointProvider.endpointRule_180()));
    }

    private static Rule endpointRule_148() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_149(), DefaultS3EndpointProvider.endpointRule_150()));
    }

    private static Rule endpointRule_147() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_148()));
    }

    private static Rule endpointRule_181() {
        return Rule.builder().error("Invalid ARN: bucket ARN is missing a region");
    }

    private static Rule endpointRule_146() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_147(), DefaultS3EndpointProvider.endpointRule_181()));
    }

    private static Rule endpointRule_144() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_145(), DefaultS3EndpointProvider.endpointRule_146()));
    }

    private static Rule endpointRule_142() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_143(), DefaultS3EndpointProvider.endpointRule_144()));
    }

    private static Rule endpointRule_141() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[1]"))).build().validate()).result("accessPointName").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointName")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_142()));
    }

    private static Rule endpointRule_182() {
        return Rule.builder().error("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided");
    }

    private static Rule endpointRule_140() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_141(), DefaultS3EndpointProvider.endpointRule_182()));
    }

    private static Rule endpointRule_139() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of("accesspoint"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_140()));
    }

    private static Rule endpointRule_183() {
        return Rule.builder().error("Invalid ARN: Object Lambda ARNs only support `accesspoint` arn types, but found: `{arnType}`");
    }

    private static Rule endpointRule_138() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("service"))).build().validate(), Expr.of("s3-object-lambda"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_139(), DefaultS3EndpointProvider.endpointRule_183()));
    }

    private static Rule endpointRule_191() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("DisableAccessPoints")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("DisableAccessPoints")), Expr.of(true))).build().validate()).build()).error("Access points are not supported for this operation");
    }

    private static Rule endpointRule_195() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of("{Region}"))).build().validate())).build().validate()).build()).error("Invalid configuration: region from ARN `{bucketArn#region}` does not match client region `{Region}` and UseArnRegion is `false`");
    }

    private static Rule endpointRule_211() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("Access Points do not support S3 Accelerate");
    }

    private static Rule endpointRule_213() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketPartition")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_215() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).error("DualStack cannot be combined with a Host override (PrivateLink)");
    }

    private static Rule endpointRule_217() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-accesspoint-fips.dualstack.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_218() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-accesspoint-fips.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_219() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-accesspoint.dualstack.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_220() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{accessPointName}-{bucketArn#accountId}.{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_221() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.s3-accesspoint.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_216() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_217(), DefaultS3EndpointProvider.endpointRule_218(), DefaultS3EndpointProvider.endpointRule_219(), DefaultS3EndpointProvider.endpointRule_220(), DefaultS3EndpointProvider.endpointRule_221()));
    }

    private static Rule endpointRule_214() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_215(), DefaultS3EndpointProvider.endpointRule_216()));
    }

    private static Rule endpointRule_212() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_213(), DefaultS3EndpointProvider.endpointRule_214()));
    }

    private static Rule endpointRule_210() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_211(), DefaultS3EndpointProvider.endpointRule_212()));
    }

    private static Rule endpointRule_209() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointName")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_210()));
    }

    private static Rule endpointRule_222() {
        return Rule.builder().error("Invalid ARN: The access point name may only contain a-z, A-Z, 0-9 and `-`. Found: `{accessPointName}`");
    }

    private static Rule endpointRule_208() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_209(), DefaultS3EndpointProvider.endpointRule_222()));
    }

    private static Rule endpointRule_207() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_208()));
    }

    private static Rule endpointRule_223() {
        return Rule.builder().error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `{bucketArn#accountId}`");
    }

    private static Rule endpointRule_206() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_207(), DefaultS3EndpointProvider.endpointRule_223()));
    }

    private static Rule endpointRule_205() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("service"))).build().validate(), Expr.of("s3"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_206()));
    }

    private static Rule endpointRule_224() {
        return Rule.builder().error("Invalid ARN: The ARN was not for the S3 service, found: {bucketArn#service}");
    }

    private static Rule endpointRule_204() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_205(), DefaultS3EndpointProvider.endpointRule_224()));
    }

    private static Rule endpointRule_203() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_204()));
    }

    private static Rule endpointRule_225() {
        return Rule.builder().error("Invalid region in ARN: `{bucketArn#region}` (invalid DNS name)");
    }

    private static Rule endpointRule_202() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_203(), DefaultS3EndpointProvider.endpointRule_225()));
    }

    private static Rule endpointRule_201() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketPartition")), Expr.of("name"))).build().validate(), Expr.of("{partitionResult#name}"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_202()));
    }

    private static Rule endpointRule_226() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but ARN (`{Bucket}`) has `{bucketPartition#name}`");
    }

    private static Rule endpointRule_200() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_201(), DefaultS3EndpointProvider.endpointRule_226()));
    }

    private static Rule endpointRule_199() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_200()));
    }

    private static Rule endpointRule_227() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_198() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_199(), DefaultS3EndpointProvider.endpointRule_227()));
    }

    private static Rule endpointRule_197() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate())).build().validate()).result("bucketPartition").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_198()));
    }

    private static Rule endpointRule_228() {
        return Rule.builder().error("Could not load partition for ARN region `{bucketArn#region}`");
    }

    private static Rule endpointRule_196() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_197(), DefaultS3EndpointProvider.endpointRule_228()));
    }

    private static Rule endpointRule_194() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_195(), DefaultS3EndpointProvider.endpointRule_196()));
    }

    private static Rule endpointRule_193() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[2]"))).build().validate())).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_194()));
    }

    private static Rule endpointRule_229() {
        return Rule.builder().error("Invalid ARN: The ARN may only contain a single resource component after `accesspoint`.");
    }

    private static Rule endpointRule_192() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_193(), DefaultS3EndpointProvider.endpointRule_229()));
    }

    private static Rule endpointRule_190() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_191(), DefaultS3EndpointProvider.endpointRule_192()));
    }

    private static Rule endpointRule_189() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_190()));
    }

    private static Rule endpointRule_230() {
        return Rule.builder().error("Invalid ARN: bucket ARN is missing a region");
    }

    private static Rule endpointRule_188() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of("accesspoint"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_189(), DefaultS3EndpointProvider.endpointRule_230()));
    }

    private static Rule endpointRule_187() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_188()));
    }

    private static Rule endpointRule_234() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("S3 MRAP does not support dual-stack");
    }

    private static Rule endpointRule_236() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("S3 MRAP does not support FIPS");
    }

    private static Rule endpointRule_238() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("S3 MRAP does not support S3 Accelerate");
    }

    private static Rule endpointRule_240() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("DisableMultiRegionAccessPoints")), Expr.of(true))).build().validate()).build()).error("Invalid configuration: Multi-Region Access Point ARNs are disabled.");
    }

    private static Rule endpointRule_245() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}.accesspoint.s3-global.{mrapPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*"))), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_244() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("mrapPartition")), Expr.of("name"))).build().validate(), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("partition"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_245()));
    }

    private static Rule endpointRule_246() {
        return Rule.builder().error("Client was configured for partition `{mrapPartition#name}` but bucket referred to partition `{bucketArn#partition}`");
    }

    private static Rule endpointRule_243() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_244(), DefaultS3EndpointProvider.endpointRule_246()));
    }

    private static Rule endpointRule_242() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("mrapPartition").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_243()));
    }

    private static Rule endpointRule_247() {
        return Rule.builder().error("{Region} was not a valid region");
    }

    private static Rule endpointRule_241() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_242(), DefaultS3EndpointProvider.endpointRule_247()));
    }

    private static Rule endpointRule_239() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_240(), DefaultS3EndpointProvider.endpointRule_241()));
    }

    private static Rule endpointRule_237() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_238(), DefaultS3EndpointProvider.endpointRule_239()));
    }

    private static Rule endpointRule_235() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_236(), DefaultS3EndpointProvider.endpointRule_237()));
    }

    private static Rule endpointRule_233() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_234(), DefaultS3EndpointProvider.endpointRule_235()));
    }

    private static Rule endpointRule_232() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointName")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_233()));
    }

    private static Rule endpointRule_248() {
        return Rule.builder().error("Invalid Access Point Name");
    }

    private static Rule endpointRule_231() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_232(), DefaultS3EndpointProvider.endpointRule_248()));
    }

    private static Rule endpointRule_186() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_187(), DefaultS3EndpointProvider.endpointRule_231()));
    }

    private static Rule endpointRule_185() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[1]"))).build().validate()).result("accessPointName").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("accessPointName")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_186()));
    }

    private static Rule endpointRule_249() {
        return Rule.builder().error("Invalid ARN: Expected a resource of the format `accesspoint:<accesspoint name>` but no name was provided");
    }

    private static Rule endpointRule_184() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of("accesspoint"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_185(), DefaultS3EndpointProvider.endpointRule_249()));
    }

    private static Rule endpointRule_251() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("S3 Outposts does not support Dual-stack");
    }

    private static Rule endpointRule_253() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("S3 Outposts does not support FIPS");
    }

    private static Rule endpointRule_255() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("S3 Outposts does not support S3 Accelerate");
    }

    private static Rule endpointRule_257() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[4]"))).build().validate())).build().validate()).build()).error("Invalid Arn: Outpost Access Point ARN contains sub resources");
    }

    private static Rule endpointRule_263() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseArnRegion")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of("{Region}"))).build().validate())).build().validate()).build()).error("Invalid configuration: region from ARN `{bucketArn#region}` does not match client region `{Region}` and UseArnRegion is `false`");
    }

    private static Rule endpointRule_281() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.{outpostId}.{url#authority}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_282() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{accessPointName}-{bucketArn#accountId}.{outpostId}.s3-outposts.{bucketArn#region}.{bucketPartition#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{bucketArn#region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-outposts"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_280() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_281(), DefaultS3EndpointProvider.endpointRule_282()));
    }

    private static Rule endpointRule_279() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("outpostType")), Expr.of("accesspoint"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_280()));
    }

    private static Rule endpointRule_283() {
        return Rule.builder().error("Expected an outpost type `accesspoint`, found {outpostType}");
    }

    private static Rule endpointRule_278() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_279(), DefaultS3EndpointProvider.endpointRule_283()));
    }

    private static Rule endpointRule_277() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[3]"))).build().validate()).result("accessPointName").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_278()));
    }

    private static Rule endpointRule_284() {
        return Rule.builder().error("Invalid ARN: expected an access point name");
    }

    private static Rule endpointRule_276() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_277(), DefaultS3EndpointProvider.endpointRule_284()));
    }

    private static Rule endpointRule_275() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[2]"))).build().validate()).result("outpostType").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_276()));
    }

    private static Rule endpointRule_285() {
        return Rule.builder().error("Invalid ARN: Expected a 4-component resource");
    }

    private static Rule endpointRule_274() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_275(), DefaultS3EndpointProvider.endpointRule_285()));
    }

    private static Rule endpointRule_273() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("accountId"))).build().validate(), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_274()));
    }

    private static Rule endpointRule_286() {
        return Rule.builder().error("Invalid ARN: The account id may only contain a-z, A-Z, 0-9 and `-`. Found: `{bucketArn#accountId}`");
    }

    private static Rule endpointRule_272() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_273(), DefaultS3EndpointProvider.endpointRule_286()));
    }

    private static Rule endpointRule_271() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate(), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_272()));
    }

    private static Rule endpointRule_287() {
        return Rule.builder().error("Invalid region in ARN: `{bucketArn#region}` (invalid DNS name)");
    }

    private static Rule endpointRule_270() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_271(), DefaultS3EndpointProvider.endpointRule_287()));
    }

    private static Rule endpointRule_269() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketPartition")), Expr.of("name"))).build().validate(), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_270()));
    }

    private static Rule endpointRule_288() {
        return Rule.builder().error("Client was configured for partition `{partitionResult#name}` but ARN (`{Bucket}`) has `{bucketPartition#name}`");
    }

    private static Rule endpointRule_268() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_269(), DefaultS3EndpointProvider.endpointRule_288()));
    }

    private static Rule endpointRule_267() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_268()));
    }

    private static Rule endpointRule_289() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_266() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_267(), DefaultS3EndpointProvider.endpointRule_289()));
    }

    private static Rule endpointRule_265() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("region"))).build().validate())).build().validate()).result("bucketPartition").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_266()));
    }

    private static Rule endpointRule_290() {
        return Rule.builder().error("Could not load partition for ARN region {bucketArn#region}");
    }

    private static Rule endpointRule_264() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_265(), DefaultS3EndpointProvider.endpointRule_290()));
    }

    private static Rule endpointRule_262() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_263(), DefaultS3EndpointProvider.endpointRule_264()));
    }

    private static Rule endpointRule_261() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("outpostId")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_262()));
    }

    private static Rule endpointRule_291() {
        return Rule.builder().error("Invalid ARN: The outpost Id may only contain a-z, A-Z, 0-9 and `-`. Found: `{outpostId}`");
    }

    private static Rule endpointRule_260() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_261(), DefaultS3EndpointProvider.endpointRule_291()));
    }

    private static Rule endpointRule_259() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[1]"))).build().validate()).result("outpostId").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_260()));
    }

    private static Rule endpointRule_292() {
        return Rule.builder().error("Invalid ARN: The Outpost Id was not set");
    }

    private static Rule endpointRule_258() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_259(), DefaultS3EndpointProvider.endpointRule_292()));
    }

    private static Rule endpointRule_256() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_257(), DefaultS3EndpointProvider.endpointRule_258()));
    }

    private static Rule endpointRule_254() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_255(), DefaultS3EndpointProvider.endpointRule_256()));
    }

    private static Rule endpointRule_252() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_253(), DefaultS3EndpointProvider.endpointRule_254()));
    }

    private static Rule endpointRule_250() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("service"))).build().validate(), Expr.of("s3-outposts"))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_251(), DefaultS3EndpointProvider.endpointRule_252()));
    }

    private static Rule endpointRule_293() {
        return Rule.builder().error("Invalid ARN: Unrecognized format: {Bucket} (type: {arnType})");
    }

    private static Rule endpointRule_137() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_138(), DefaultS3EndpointProvider.endpointRule_184(), DefaultS3EndpointProvider.endpointRule_250(), DefaultS3EndpointProvider.endpointRule_293()));
    }

    private static Rule endpointRule_136() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("bucketArn")), Expr.of("resourceId[0]"))).build().validate()).result("arnType").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnType")), Expr.of(""))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_137()));
    }

    private static Rule endpointRule_294() {
        return Rule.builder().error("Invalid ARN: No ARN type specified");
    }

    private static Rule endpointRule_135() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).result("bucketArn").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_136(), DefaultS3EndpointProvider.endpointRule_294()));
    }

    private static Rule endpointRule_295() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("substring").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")), Expr.of(0), Expr.of(4), Expr.of(false))).build().validate()).result("arnPrefix").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("arnPrefix")), Expr.of("arn:"))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(FnNode.builder().fn("aws.parseArn").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate())).build().validate())).build().validate()).build()).error("Invalid ARN: `{Bucket}` was not a valid ARN");
    }

    private static Rule endpointRule_297() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).error("Cannot set dual-stack in combination with a custom endpoint.");
    }

    private static Rule endpointRule_303() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_304() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_306() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_305() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_306()));
    }

    private static Rule endpointRule_307() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_308() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_309() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_311() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_310() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_311()));
    }

    private static Rule endpointRule_312() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_313() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_314() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_316() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_315() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_316()));
    }

    private static Rule endpointRule_317() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_318() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_319() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_321() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_320() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_321()));
    }

    private static Rule endpointRule_322() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_323() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_324() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_326() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_327() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_325() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_326(), DefaultS3EndpointProvider.endpointRule_327()));
    }

    private static Rule endpointRule_328() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#normalizedPath}{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_329() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_330() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_332() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_333() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_331() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_332(), DefaultS3EndpointProvider.endpointRule_333()));
    }

    private static Rule endpointRule_334() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}/{uri_encoded_bucket}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_302() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_303(), DefaultS3EndpointProvider.endpointRule_304(), DefaultS3EndpointProvider.endpointRule_305(), DefaultS3EndpointProvider.endpointRule_307(), DefaultS3EndpointProvider.endpointRule_308(), DefaultS3EndpointProvider.endpointRule_309(), DefaultS3EndpointProvider.endpointRule_310(), DefaultS3EndpointProvider.endpointRule_312(), DefaultS3EndpointProvider.endpointRule_313(), DefaultS3EndpointProvider.endpointRule_314(), DefaultS3EndpointProvider.endpointRule_315(), DefaultS3EndpointProvider.endpointRule_317(), DefaultS3EndpointProvider.endpointRule_318(), DefaultS3EndpointProvider.endpointRule_319(), DefaultS3EndpointProvider.endpointRule_320(), DefaultS3EndpointProvider.endpointRule_322(), DefaultS3EndpointProvider.endpointRule_323(), DefaultS3EndpointProvider.endpointRule_324(), DefaultS3EndpointProvider.endpointRule_325(), DefaultS3EndpointProvider.endpointRule_328(), DefaultS3EndpointProvider.endpointRule_329(), DefaultS3EndpointProvider.endpointRule_330(), DefaultS3EndpointProvider.endpointRule_331(), DefaultS3EndpointProvider.endpointRule_334()));
    }

    private static Rule endpointRule_301() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_302()));
    }

    private static Rule endpointRule_335() {
        return Rule.builder().error("Path-style addressing cannot be used with S3 Accelerate");
    }

    private static Rule endpointRule_300() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_301(), DefaultS3EndpointProvider.endpointRule_335()));
    }

    private static Rule endpointRule_299() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_300()));
    }

    private static Rule endpointRule_336() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_298() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_299(), DefaultS3EndpointProvider.endpointRule_336()));
    }

    private static Rule endpointRule_296() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("uriEncode").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).result("uri_encoded_bucket").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_297(), DefaultS3EndpointProvider.endpointRule_298()));
    }

    private static Rule endpointRule_20() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_21(), DefaultS3EndpointProvider.endpointRule_65(), DefaultS3EndpointProvider.endpointRule_128(), DefaultS3EndpointProvider.endpointRule_135(), DefaultS3EndpointProvider.endpointRule_295(), DefaultS3EndpointProvider.endpointRule_296()));
    }

    private static Rule endpointRule_18() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_19(), DefaultS3EndpointProvider.endpointRule_20()));
    }

    private static Rule endpointRule_342() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("S3 Object Lambda does not support Dual-stack");
    }

    private static Rule endpointRule_344() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Accelerate")), Expr.of(true))).build().validate()).build()).error("S3 Object Lambda does not support S3 Accelerate");
    }

    private static Rule endpointRule_346() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_348() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_349() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-object-lambda-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_350() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-object-lambda.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3-object-lambda"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_347() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_348(), DefaultS3EndpointProvider.endpointRule_349(), DefaultS3EndpointProvider.endpointRule_350()));
    }

    private static Rule endpointRule_345() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_346(), DefaultS3EndpointProvider.endpointRule_347()));
    }

    private static Rule endpointRule_343() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_344(), DefaultS3EndpointProvider.endpointRule_345()));
    }

    private static Rule endpointRule_341() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_342(), DefaultS3EndpointProvider.endpointRule_343()));
    }

    private static Rule endpointRule_340() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_341()));
    }

    private static Rule endpointRule_351() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_339() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_340(), DefaultS3EndpointProvider.endpointRule_351()));
    }

    private static Rule endpointRule_338() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_339()));
    }

    private static Rule endpointRule_352() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_337() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("UseObjectLambdaEndpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseObjectLambdaEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_338(), DefaultS3EndpointProvider.endpointRule_352()));
    }

    private static Rule endpointRule_358() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("partitionResult")), Expr.of("name"))).build().validate(), Expr.of("aws-cn"))).build().validate()).build()).error("Partition does not support FIPS");
    }

    private static Rule endpointRule_360() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_361() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_363() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_362() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_363()));
    }

    private static Rule endpointRule_364() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_365() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_366() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_368() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_367() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_368()));
    }

    private static Rule endpointRule_369() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_370() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_371() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_373() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_372() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_373()));
    }

    private static Rule endpointRule_374() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_375() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_376() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_378() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_377() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_378()));
    }

    private static Rule endpointRule_379() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3-fips.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_380() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_381() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_383() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_382() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_383()));
    }

    private static Rule endpointRule_384() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_385() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_386() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.us-east-1.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_388() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_387() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_388()));
    }

    private static Rule endpointRule_389() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.dualstack.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_390() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_391() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_393() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_394() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_392() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_393(), DefaultS3EndpointProvider.endpointRule_394()));
    }

    private static Rule endpointRule_395() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("parseURL").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).result("url").build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("{url#scheme}://{url#authority}{url#path}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_396() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_397() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("us-east-1"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_399() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_400() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_398() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_399(), DefaultS3EndpointProvider.endpointRule_400()));
    }

    private static Rule endpointRule_401() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(false))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("aws-global"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseGlobalEndpoint")), Expr.of(false))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://s3.{Region}.{partitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4"), (Object)Identifier.of("signingRegion"), (Object)Literal.fromStr("{Region}"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("s3"), (Object)Identifier.of("disableDoubleEncoding"), (Object)Literal.fromBool(true)))))).build());
    }

    private static Rule endpointRule_359() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_360(), DefaultS3EndpointProvider.endpointRule_361(), DefaultS3EndpointProvider.endpointRule_362(), DefaultS3EndpointProvider.endpointRule_364(), DefaultS3EndpointProvider.endpointRule_365(), DefaultS3EndpointProvider.endpointRule_366(), DefaultS3EndpointProvider.endpointRule_367(), DefaultS3EndpointProvider.endpointRule_369(), DefaultS3EndpointProvider.endpointRule_370(), DefaultS3EndpointProvider.endpointRule_371(), DefaultS3EndpointProvider.endpointRule_372(), DefaultS3EndpointProvider.endpointRule_374(), DefaultS3EndpointProvider.endpointRule_375(), DefaultS3EndpointProvider.endpointRule_376(), DefaultS3EndpointProvider.endpointRule_377(), DefaultS3EndpointProvider.endpointRule_379(), DefaultS3EndpointProvider.endpointRule_380(), DefaultS3EndpointProvider.endpointRule_381(), DefaultS3EndpointProvider.endpointRule_382(), DefaultS3EndpointProvider.endpointRule_384(), DefaultS3EndpointProvider.endpointRule_385(), DefaultS3EndpointProvider.endpointRule_386(), DefaultS3EndpointProvider.endpointRule_387(), DefaultS3EndpointProvider.endpointRule_389(), DefaultS3EndpointProvider.endpointRule_390(), DefaultS3EndpointProvider.endpointRule_391(), DefaultS3EndpointProvider.endpointRule_392(), DefaultS3EndpointProvider.endpointRule_395(), DefaultS3EndpointProvider.endpointRule_396(), DefaultS3EndpointProvider.endpointRule_397(), DefaultS3EndpointProvider.endpointRule_398(), DefaultS3EndpointProvider.endpointRule_401()));
    }

    private static Rule endpointRule_357() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_358(), DefaultS3EndpointProvider.endpointRule_359()));
    }

    private static Rule endpointRule_356() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_357()));
    }

    private static Rule endpointRule_402() {
        return Rule.builder().error("Invalid region: region was not a valid DNS name.");
    }

    private static Rule endpointRule_355() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_356(), DefaultS3EndpointProvider.endpointRule_402()));
    }

    private static Rule endpointRule_354() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("partitionResult").build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_355()));
    }

    private static Rule endpointRule_403() {
        return Rule.builder().error("A valid partition could not be determined");
    }

    private static Rule endpointRule_353() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("not").argv(Arrays.asList(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Bucket")))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_354(), DefaultS3EndpointProvider.endpointRule_403()));
    }

    private static Rule endpointRule_2() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_3(), DefaultS3EndpointProvider.endpointRule_18(), DefaultS3EndpointProvider.endpointRule_337(), DefaultS3EndpointProvider.endpointRule_353()));
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).build()).treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_2()));
    }

    private static Rule endpointRule_404() {
        return Rule.builder().error("A region must be set when sending requests to S3.");
    }

    private static Rule endpointRule_0() {
        return Rule.builder().treeRule(Arrays.asList(DefaultS3EndpointProvider.endpointRule_1(), DefaultS3EndpointProvider.endpointRule_404()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Bucket").type(ParameterType.fromValue("String")).required(false).documentation("The S3 bucket used to send the request. This is an optional parameter that will be set automatically for operations that are scoped to an S3 bucket.").build()).addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(false).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).addParameter(Parameter.builder().name("ForcePathStyle").type(ParameterType.fromValue("Boolean")).required(false).builtIn("AWS::S3::ForcePathStyle").documentation("When true, force a path-style endpoint to be used where the bucket name is part of the path.").build()).addParameter(Parameter.builder().name("Accelerate").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::S3::Accelerate").documentation("When true, use S3 Accelerate. NOTE: Not all regions support S3 accelerate.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseGlobalEndpoint").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::S3::UseGlobalEndpoint").documentation("Whether the global endpoint should be used, rather then the regional endpoint for us-east-1.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseObjectLambdaEndpoint").type(ParameterType.fromValue("Boolean")).required(false).documentation("Internal parameter to use object lambda endpoint for an operation (eg: WriteGetObjectResponse)").build()).addParameter(Parameter.builder().name("DisableAccessPoints").type(ParameterType.fromValue("Boolean")).required(false).documentation("Internal parameter to disable Access Point Buckets").build()).addParameter(Parameter.builder().name("DisableMultiRegionAccessPoints").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::S3::DisableMultiRegionAccessPoints").documentation("Whether multi-region access points (MRAP) should be disabled.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseArnRegion").type(ParameterType.fromValue("Boolean")).required(false).builtIn("AWS::S3::UseArnRegion").documentation("When an Access Point ARN is provided and this flag is enabled, the SDK MUST use the ARN's region when constructing the endpoint instead of the client's configured region.").build()).build()).addRule(DefaultS3EndpointProvider.endpointRule_0()).build();
    }
}

