/*
 * Decompiled with CFR 0.152.
 */
package us.springett.parsers.cpe.util;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Versions {
    private Versions() {
    }

    public static List<VersionPart> splitVersion(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptyList();
        }
        VersionParserState token = new VersionParserState();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Versions.isSplitter(c)) {
                token.complete();
                continue;
            }
            if (Versions.isDigit(c) && token.mode.numeric()) {
                token.appendDigit(c);
                continue;
            }
            if (Versions.isDigit(c) && !token.mode.numeric()) {
                token.complete();
                token.appendDigit(c);
                continue;
            }
            if (token.mode.numeric()) {
                token.complete();
                token.append(c);
                continue;
            }
            token.append(c);
        }
        token.complete();
        return token.parts;
    }

    private static boolean isSplitter(char c) {
        return c == '.' || c == '|' || c == ':' || c == '-';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static class VersionPart
    implements Comparable<VersionPart> {
        private final String part;

        private VersionPart(String part) {
            this.part = part;
        }

        boolean compareAsInteger() {
            return false;
        }

        @Override
        public int compareTo(VersionPart o) {
            return this.compareAsInteger() && o.compareAsInteger() ? this.compareToInteger(o) : this.part.compareTo(o.part);
        }

        private int compareToInteger(VersionPart o) {
            try {
                return Long.compare(Long.parseLong(this.part), Long.parseLong(o.part));
            }
            catch (NumberFormatException ignored) {
                return new BigInteger(this.part).compareTo(new BigInteger(o.part));
            }
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VersionPart that = (VersionPart)o;
            return this.compareAsInteger() == that.compareAsInteger() && Objects.equals(this.part, that.part);
        }

        public int hashCode() {
            return Objects.hash(this.compareAsInteger(), this.part);
        }

        public String toString() {
            return this.part + (this.compareAsInteger() ? "(int)" : "");
        }

        static VersionPart strPart(String val) {
            return new VersionPart(val);
        }

        static VersionPart intPart(String val) {
            return new VersionPart(val){

                @Override
                boolean compareAsInteger() {
                    return true;
                }
            };
        }
    }

    private static class VersionParserState {
        private final List<VersionPart> parts = new ArrayList<VersionPart>(3);
        private final StringBuilder token = new StringBuilder(3);
        private VersionParserMode mode = VersionParserMode.String;

        private VersionParserState() {
        }

        boolean empty() {
            return this.token.length() == 0;
        }

        void append(char c) {
            this.token.append(c);
        }

        void appendDigit(char c) {
            if (this.empty()) {
                this.mode = c == '0' ? VersionParserMode.IntegerAsString : VersionParserMode.Integer;
            }
            this.append(c);
        }

        void complete() {
            if (!this.empty()) {
                this.parts.add(this.mode.toPart(this.token.toString()));
            }
            this.token.setLength(0);
            this.mode = VersionParserMode.String;
        }
    }

    private static enum VersionParserMode {
        String,
        Integer,
        IntegerAsString;


        boolean numeric() {
            return this == Integer || this == IntegerAsString;
        }

        VersionPart toPart(String val) {
            return this == Integer ? VersionPart.intPart(val) : VersionPart.strPart(val);
        }
    }
}

