// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.presigners

import aws.sdk.kotlin.services.s3.S3Client
import aws.sdk.kotlin.services.s3.endpoints.internal.EndpointResolverAdapter
import aws.sdk.kotlin.services.s3.model.GetObjectRequest
import aws.sdk.kotlin.services.s3.model.PutObjectRequest
import aws.sdk.kotlin.services.s3.model.UploadPartRequest
import aws.sdk.kotlin.services.s3.serde.GetObjectOperationSerializer
import aws.sdk.kotlin.services.s3.serde.PutObjectOperationSerializer
import aws.sdk.kotlin.services.s3.serde.UploadPartOperationSerializer
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.presignRequest
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContext
import aws.smithy.kotlin.runtime.http.request.HttpRequest
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import kotlin.time.Duration

/**
 * Presign a [GetObjectRequest] using the configuration of this [S3Client].
 * @param input The [GetObjectRequest] to presign
 * @param duration The amount of time from signing for which the request is valid
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignGetObject(input: GetObjectRequest, duration: Duration): HttpRequest =
    presignGetObject(input) { expiresAfter = duration }

/**
 * Presign a [GetObjectRequest] using the configuration of this [S3Client].
 * @param input The [GetObjectRequest] to presign
 * @param signer The specific implementation of AWS signer to use. Defaults to DefaultAwsSigner.
 * @param configBlock A builder block for setting custom signing parameters. At a minimum the
 * [expiresAfter] field must be set.
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignGetObject(
    input: GetObjectRequest,
    signer: AwsSigner = DefaultAwsSigner,
    configBlock: AwsSigningConfig.Builder.() -> Unit,
): HttpRequest {
    val ctx = ExecutionContext().apply {
        set(SdkClientOption.OperationName, "GetObject")
        set(HttpOperationContext.OperationInput, input)
    }
    val unsignedRequest = GetObjectOperationSerializer().serialize(ctx, input)
    val endpointResolver = EndpointResolverAdapter(config)

    return presignRequest(unsignedRequest, ctx, config.credentialsProvider, endpointResolver, signer) {
        if (service == null) service = "s3"
        if (region == null) region = config.region
        useDoubleUriEncode = false
        normalizeUriPath = false
        configBlock()
    }
}

/**
 * Presign a [PutObjectRequest] using the configuration of this [S3Client].
 * @param input The [PutObjectRequest] to presign
 * @param duration The amount of time from signing for which the request is valid
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignPutObject(input: PutObjectRequest, duration: Duration): HttpRequest =
    presignPutObject(input) { expiresAfter = duration }

/**
 * Presign a [PutObjectRequest] using the configuration of this [S3Client].
 * @param input The [PutObjectRequest] to presign
 * @param signer The specific implementation of AWS signer to use. Defaults to DefaultAwsSigner.
 * @param configBlock A builder block for setting custom signing parameters. At a minimum the
 * [expiresAfter] field must be set.
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignPutObject(
    input: PutObjectRequest,
    signer: AwsSigner = DefaultAwsSigner,
    configBlock: AwsSigningConfig.Builder.() -> Unit,
): HttpRequest {
    val ctx = ExecutionContext().apply {
        set(SdkClientOption.OperationName, "PutObject")
        set(HttpOperationContext.OperationInput, input)
    }
    val unsignedRequest = PutObjectOperationSerializer().serialize(ctx, input)
    val endpointResolver = EndpointResolverAdapter(config)

    return presignRequest(unsignedRequest, ctx, config.credentialsProvider, endpointResolver, signer) {
        if (service == null) service = "s3"
        if (region == null) region = config.region
        useDoubleUriEncode = false
        normalizeUriPath = false
        configBlock()
    }
}

/**
 * Presign a [UploadPartRequest] using the configuration of this [S3Client].
 * @param input The [UploadPartRequest] to presign
 * @param duration The amount of time from signing for which the request is valid
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignUploadPart(input: UploadPartRequest, duration: Duration): HttpRequest =
    presignUploadPart(input) { expiresAfter = duration }

/**
 * Presign a [UploadPartRequest] using the configuration of this [S3Client].
 * @param input The [UploadPartRequest] to presign
 * @param signer The specific implementation of AWS signer to use. Defaults to DefaultAwsSigner.
 * @param configBlock A builder block for setting custom signing parameters. At a minimum the
 * [expiresAfter] field must be set.
 * @return An [HttpRequest] which can be invoked within the specified time window
 */
public suspend fun S3Client.presignUploadPart(
    input: UploadPartRequest,
    signer: AwsSigner = DefaultAwsSigner,
    configBlock: AwsSigningConfig.Builder.() -> Unit,
): HttpRequest {
    val ctx = ExecutionContext().apply {
        set(SdkClientOption.OperationName, "UploadPart")
        set(HttpOperationContext.OperationInput, input)
    }
    val unsignedRequest = UploadPartOperationSerializer().serialize(ctx, input)
    val endpointResolver = EndpointResolverAdapter(config)

    return presignRequest(unsignedRequest, ctx, config.credentialsProvider, endpointResolver, signer) {
        if (service == null) service = "s3"
        if (region == null) region = config.region
        useDoubleUriEncode = false
        normalizeUriPath = false
        configBlock()
    }
}
