/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.s3.internal;

import aws.sdk.kotlin.runtime.AwsServiceException;
import aws.sdk.kotlin.services.s3.internal.S3ErrorDetails;
import aws.sdk.kotlin.services.s3.model.S3ErrorMetadata;
import aws.sdk.kotlin.services.s3.model.S3Exception;
import aws.smithy.kotlin.runtime.ServiceErrorMetadata;
import aws.smithy.kotlin.runtime.awsprotocol.AwsErrorDetails;
import aws.smithy.kotlin.runtime.awsprotocol.ProtocolErrorsKt;
import aws.smithy.kotlin.runtime.collections.AttributeKey;
import aws.smithy.kotlin.runtime.collections.AttributesKt;
import aws.smithy.kotlin.runtime.collections.MutableAttributes;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.serde.Deserializer;
import aws.smithy.kotlin.runtime.serde.FieldTrait;
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor;
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor;
import aws.smithy.kotlin.runtime.serde.SerialKind;
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer;
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"X_AMZN_REQUEST_ID_2_HEADER", "", "parseS3ErrorResponse", "Laws/sdk/kotlin/services/s3/internal/S3ErrorDetails;", "payload", "", "setS3ErrorMetadata", "", "exception", "", "response", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "errorDetails", "s3"})
@SourceDebugExtension(value={"SMAP\nS3ErrorMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 S3ErrorMetadata.kt\naws/sdk/kotlin/services/s3/internal/S3ErrorMetadataKt\n+ 2 SdkObjectDescriptor.kt\naws/smithy/kotlin/runtime/serde/SdkObjectDescriptor$Companion\n+ 3 Deserializer.kt\naws/smithy/kotlin/runtime/serde/DeserializerKt\n*L\n1#1,81:1\n21#2:82\n230#3,3:83\n*S KotlinDebug\n*F\n+ 1 S3ErrorMetadata.kt\naws/sdk/kotlin/services/s3/internal/S3ErrorMetadataKt\n*L\n52#1:82\n66#1:83,3\n*E\n"})
public final class S3ErrorMetadataKt {
    @NotNull
    private static final String X_AMZN_REQUEST_ID_2_HEADER = "x-amz-id-2";

    public static final void setS3ErrorMetadata(@NotNull Object exception, @NotNull HttpResponse response, @Nullable S3ErrorDetails errorDetails) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        ProtocolErrorsKt.setAseErrorMetadata((Object)exception, (HttpResponse)response, (AwsErrorDetails)errorDetails);
        if (exception instanceof AwsServiceException) {
            S3ErrorDetails s3ErrorDetails = errorDetails;
            AttributesKt.setIfValueNotNull((MutableAttributes)((AwsServiceException)exception).getSdkErrorMetadata().getAttributes(), (AttributeKey)ServiceErrorMetadata.Companion.getRequestId(), (Object)(s3ErrorDetails != null ? s3ErrorDetails.getRequestId() : null));
        }
        if (exception instanceof S3Exception) {
            Object object = errorDetails;
            if (object == null || (object = ((S3ErrorDetails)object).getRequestId2()) == null) {
                object = (String)response.getHeaders().get(X_AMZN_REQUEST_ID_2_HEADER);
            }
            Object requestId2 = object;
            AttributesKt.setIfValueNotNull((MutableAttributes)((S3Exception)((Object)exception)).getSdkErrorMetadata().getAttributes(), S3ErrorMetadata.Companion.getRequestId2(), (Object)requestId2);
        }
    }

    @NotNull
    public static final S3ErrorDetails parseS3ErrorResponse(@NotNull byte[] payload) {
        Deserializer.FieldIterator deserializer$iv;
        SdkObjectDescriptor.Builder builder;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        FieldTrait[] fieldTraitArray = new FieldTrait[]{new XmlSerialName("Message")};
        SdkFieldDescriptor MESSAGE_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray);
        FieldTrait[] fieldTraitArray2 = new FieldTrait[]{new XmlSerialName("Code")};
        SdkFieldDescriptor CODE_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray2);
        FieldTrait[] fieldTraitArray3 = new FieldTrait[]{new XmlSerialName("RequestId")};
        SdkFieldDescriptor REQUESTID_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray3);
        FieldTrait[] fieldTraitArray4 = new FieldTrait[]{new XmlSerialName("HostId")};
        SdkFieldDescriptor HOSTID_DESCRIPTOR = new SdkFieldDescriptor((SerialKind)SerialKind.String.INSTANCE, fieldTraitArray4);
        SdkObjectDescriptor.Companion this_$iv = SdkObjectDescriptor.Companion;
        boolean $i$f$build = false;
        SdkObjectDescriptor.Builder $this$parseS3ErrorResponse_u24lambda_u240 = builder = new SdkObjectDescriptor.Builder();
        boolean bl = false;
        $this$parseS3ErrorResponse_u24lambda_u240.trait((FieldTrait)new XmlSerialName("Error"));
        $this$parseS3ErrorResponse_u24lambda_u240.field(MESSAGE_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u240.field(CODE_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u240.field(REQUESTID_DESCRIPTOR);
        $this$parseS3ErrorResponse_u24lambda_u240.field(HOSTID_DESCRIPTOR);
        SdkObjectDescriptor OBJ_DESCRIPTOR = builder.build();
        String message = null;
        String code = null;
        String requestId = null;
        String requestId2 = null;
        XmlDeserializer deserializer = new XmlDeserializer(payload, true);
        Deserializer $this$deserializeStruct$iv = (Deserializer)deserializer;
        boolean $i$f$deserializeStruct = false;
        Deserializer.FieldIterator $this$parseS3ErrorResponse_u24lambda_u241 = deserializer$iv = $this$deserializeStruct$iv.deserializeStruct(OBJ_DESCRIPTOR);
        boolean bl2 = false;
        while (true) {
            Integer n;
            Integer n2 = n = $this$parseS3ErrorResponse_u24lambda_u241.findNextFieldIndex();
            int n3 = MESSAGE_DESCRIPTOR.getIndex();
            if (n2 != null && n2 == n3) {
                message = $this$parseS3ErrorResponse_u24lambda_u241.deserializeString();
                continue;
            }
            Integer n4 = n;
            n3 = CODE_DESCRIPTOR.getIndex();
            if (n4 != null && n4 == n3) {
                code = $this$parseS3ErrorResponse_u24lambda_u241.deserializeString();
                continue;
            }
            Integer n5 = n;
            n3 = REQUESTID_DESCRIPTOR.getIndex();
            if (n5 != null && n5 == n3) {
                requestId = $this$parseS3ErrorResponse_u24lambda_u241.deserializeString();
                continue;
            }
            Integer n6 = n;
            n3 = HOSTID_DESCRIPTOR.getIndex();
            if (n6 != null && n6 == n3) {
                requestId2 = $this$parseS3ErrorResponse_u24lambda_u241.deserializeString();
                continue;
            }
            if (n == null) break;
            $this$parseS3ErrorResponse_u24lambda_u241.skipValue();
        }
        return new S3ErrorDetails(code, message, requestId, requestId2);
    }
}

