// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class CreateBucketRequest private constructor(builder: Builder) {
    /**
     * The canned ACL to apply to the bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val acl: aws.sdk.kotlin.services.s3.model.BucketCannedAcl? = builder.acl
    /**
     * The name of the bucket to create.
     *
     * **General purpose buckets** - For information about bucket naming restrictions, see [Bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) in the *Amazon S3 User Guide*.
     *
     * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must also follow the format ` <i>bucket_base_name</i>--<i>az_id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * The configuration information for the bucket.
     */
    public val createBucketConfiguration: aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration? = builder.createBucketConfiguration
    /**
     * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val grantFullControl: kotlin.String? = builder.grantFullControl
    /**
     * Allows grantee to list the objects in the bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val grantRead: kotlin.String? = builder.grantRead
    /**
     * Allows grantee to read the bucket ACL.
     *
     * This functionality is not supported for directory buckets.
     */
    public val grantReadAcp: kotlin.String? = builder.grantReadAcp
    /**
     * Allows grantee to create new objects in the bucket.
     *
     * For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.
     *
     * This functionality is not supported for directory buckets.
     */
    public val grantWrite: kotlin.String? = builder.grantWrite
    /**
     * Allows grantee to write the ACL for the applicable bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val grantWriteAcp: kotlin.String? = builder.grantWriteAcp
    /**
     * Specifies whether you want S3 Object Lock to be enabled for the new bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val objectLockEnabledForBucket: kotlin.Boolean? = builder.objectLockEnabledForBucket
    /**
     * The container element for object ownership for a bucket's ownership controls.
     *
     * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * `ObjectWriter` - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
     *
     * `BucketOwnerEnforced` - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or specify bucket owner full control ACLs (such as the predefined `bucket-owner-full-control` canned ACL or a custom ACL in XML format that grants the same permissions).
     *
     * By default, `ObjectOwnership` is set to `BucketOwnerEnforced` and ACLs are disabled. We recommend keeping ACLs disabled, except in uncommon use cases where you must control access for each object individually. For more information about S3 Object Ownership, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
     *
     * This functionality is not supported for directory buckets. Directory buckets use the bucket owner enforced setting for S3 Object Ownership.
     */
    public val objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership? = builder.objectOwnership

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.CreateBucketRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBucketRequest(")
        append("acl=$acl,")
        append("bucket=$bucket,")
        append("createBucketConfiguration=$createBucketConfiguration,")
        append("grantFullControl=$grantFullControl,")
        append("grantRead=$grantRead,")
        append("grantReadAcp=$grantReadAcp,")
        append("grantWrite=$grantWrite,")
        append("grantWriteAcp=$grantWriteAcp,")
        append("objectLockEnabledForBucket=$objectLockEnabledForBucket,")
        append("objectOwnership=$objectOwnership")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acl?.hashCode() ?: 0
        result = 31 * result + (bucket?.hashCode() ?: 0)
        result = 31 * result + (createBucketConfiguration?.hashCode() ?: 0)
        result = 31 * result + (grantFullControl?.hashCode() ?: 0)
        result = 31 * result + (grantRead?.hashCode() ?: 0)
        result = 31 * result + (grantReadAcp?.hashCode() ?: 0)
        result = 31 * result + (grantWrite?.hashCode() ?: 0)
        result = 31 * result + (grantWriteAcp?.hashCode() ?: 0)
        result = 31 * result + (objectLockEnabledForBucket?.hashCode() ?: 0)
        result = 31 * result + (objectOwnership?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBucketRequest

        if (acl != other.acl) return false
        if (bucket != other.bucket) return false
        if (createBucketConfiguration != other.createBucketConfiguration) return false
        if (grantFullControl != other.grantFullControl) return false
        if (grantRead != other.grantRead) return false
        if (grantReadAcp != other.grantReadAcp) return false
        if (grantWrite != other.grantWrite) return false
        if (grantWriteAcp != other.grantWriteAcp) return false
        if (objectLockEnabledForBucket != other.objectLockEnabledForBucket) return false
        if (objectOwnership != other.objectOwnership) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.CreateBucketRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The canned ACL to apply to the bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var acl: aws.sdk.kotlin.services.s3.model.BucketCannedAcl? = null
        /**
         * The name of the bucket to create.
         *
         * **General purpose buckets** - For information about bucket naming restrictions, see [Bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html) in the *Amazon S3 User Guide*.
         *
         * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must also follow the format ` <i>bucket_base_name</i>--<i>az_id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
         */
        public var bucket: kotlin.String? = null
        /**
         * The configuration information for the bucket.
         */
        public var createBucketConfiguration: aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration? = null
        /**
         * Allows grantee the read, write, read ACP, and write ACP permissions on the bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var grantFullControl: kotlin.String? = null
        /**
         * Allows grantee to list the objects in the bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var grantRead: kotlin.String? = null
        /**
         * Allows grantee to read the bucket ACL.
         *
         * This functionality is not supported for directory buckets.
         */
        public var grantReadAcp: kotlin.String? = null
        /**
         * Allows grantee to create new objects in the bucket.
         *
         * For the bucket and object owners of existing objects, also allows deletions and overwrites of those objects.
         *
         * This functionality is not supported for directory buckets.
         */
        public var grantWrite: kotlin.String? = null
        /**
         * Allows grantee to write the ACL for the applicable bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var grantWriteAcp: kotlin.String? = null
        /**
         * Specifies whether you want S3 Object Lock to be enabled for the new bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var objectLockEnabledForBucket: kotlin.Boolean? = null
        /**
         * The container element for object ownership for a bucket's ownership controls.
         *
         * `BucketOwnerPreferred` - Objects uploaded to the bucket change ownership to the bucket owner if the objects are uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * `ObjectWriter` - The uploading account will own the object if the object is uploaded with the `bucket-owner-full-control` canned ACL.
         *
         * `BucketOwnerEnforced` - Access control lists (ACLs) are disabled and no longer affect permissions. The bucket owner automatically owns and has full control over every object in the bucket. The bucket only accepts PUT requests that don't specify an ACL or specify bucket owner full control ACLs (such as the predefined `bucket-owner-full-control` canned ACL or a custom ACL in XML format that grants the same permissions).
         *
         * By default, `ObjectOwnership` is set to `BucketOwnerEnforced` and ACLs are disabled. We recommend keeping ACLs disabled, except in uncommon use cases where you must control access for each object individually. For more information about S3 Object Ownership, see [Controlling ownership of objects and disabling ACLs for your bucket](https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html) in the *Amazon S3 User Guide*.
         *
         * This functionality is not supported for directory buckets. Directory buckets use the bucket owner enforced setting for S3 Object Ownership.
         */
        public var objectOwnership: aws.sdk.kotlin.services.s3.model.ObjectOwnership? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.CreateBucketRequest) : this() {
            this.acl = x.acl
            this.bucket = x.bucket
            this.createBucketConfiguration = x.createBucketConfiguration
            this.grantFullControl = x.grantFullControl
            this.grantRead = x.grantRead
            this.grantReadAcp = x.grantReadAcp
            this.grantWrite = x.grantWrite
            this.grantWriteAcp = x.grantWriteAcp
            this.objectLockEnabledForBucket = x.objectLockEnabledForBucket
            this.objectOwnership = x.objectOwnership
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.CreateBucketRequest = CreateBucketRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration] inside the given [block]
         */
        public fun createBucketConfiguration(block: aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration.Builder.() -> kotlin.Unit) {
            this.createBucketConfiguration = aws.sdk.kotlin.services.s3.model.CreateBucketConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
