// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class ListObjectsV2Request private constructor(builder: Builder) {
    /**
     * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
     *
     * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
     *
     * Access points and Object Lambda access points are not supported by directory buckets.
     *
     * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * `ContinuationToken` indicates to Amazon S3 that the list is being continued on this bucket with a token. `ContinuationToken` is obfuscated and is not a real key. You can use this `ContinuationToken` for pagination of the list results.
     */
    public val continuationToken: kotlin.String? = builder.continuationToken
    /**
     * A delimiter is a character that you use to group keys.
     *
     * + **Directory buckets** - For directory buckets, `/` is the only supported delimiter.
     * + **Directory buckets ** - When you query `ListObjectsV2` with a delimiter during in-progress multipart uploads, the `CommonPrefixes` response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see [Multipart Upload Overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the *Amazon S3 User Guide*.
     */
    public val delimiter: kotlin.String? = builder.delimiter
    /**
     * Encoding type used by Amazon S3 to encode object keys in the response. If using `url`, non-ASCII characters used in an object's key name will be URL encoded. For example, the object test_file(3).png will appear as test_file%283%29.png.
     */
    public val encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = builder.encodingType
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The owner field is not present in `ListObjectsV2` by default. If you want to return the owner field with each key in the result, then set the `FetchOwner` field to `true`.
     *
     * **Directory buckets** - For directory buckets, the bucket owner is returned as the object owner for all objects.
     */
    public val fetchOwner: kotlin.Boolean? = builder.fetchOwner
    /**
     * Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.
     */
    public val maxKeys: kotlin.Int? = builder.maxKeys
    /**
     * Specifies the optional fields that you want returned in the response. Fields that you do not specify are not returned.
     *
     * This functionality is not supported for directory buckets.
     */
    public val optionalObjectAttributes: List<OptionalObjectAttributes>? = builder.optionalObjectAttributes
    /**
     * Limits the response to keys that begin with the specified prefix.
     *
     * **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
     */
    public val prefix: kotlin.String? = builder.prefix
    /**
     * Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.
     *
     * This functionality is not supported for directory buckets.
     */
    public val requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = builder.requestPayer
    /**
     * StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.
     *
     * This functionality is not supported for directory buckets.
     */
    public val startAfter: kotlin.String? = builder.startAfter

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.ListObjectsV2Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListObjectsV2Request(")
        append("bucket=$bucket,")
        append("continuationToken=$continuationToken,")
        append("delimiter=$delimiter,")
        append("encodingType=$encodingType,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("fetchOwner=$fetchOwner,")
        append("maxKeys=$maxKeys,")
        append("optionalObjectAttributes=$optionalObjectAttributes,")
        append("prefix=$prefix,")
        append("requestPayer=$requestPayer,")
        append("startAfter=$startAfter")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (continuationToken?.hashCode() ?: 0)
        result = 31 * result + (delimiter?.hashCode() ?: 0)
        result = 31 * result + (encodingType?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (fetchOwner?.hashCode() ?: 0)
        result = 31 * result + (maxKeys ?: 0)
        result = 31 * result + (optionalObjectAttributes?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (requestPayer?.hashCode() ?: 0)
        result = 31 * result + (startAfter?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListObjectsV2Request

        if (bucket != other.bucket) return false
        if (continuationToken != other.continuationToken) return false
        if (delimiter != other.delimiter) return false
        if (encodingType != other.encodingType) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (fetchOwner != other.fetchOwner) return false
        if (maxKeys != other.maxKeys) return false
        if (optionalObjectAttributes != other.optionalObjectAttributes) return false
        if (prefix != other.prefix) return false
        if (requestPayer != other.requestPayer) return false
        if (startAfter != other.startAfter) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.ListObjectsV2Request = Builder(this).apply(block).build()

    public class Builder {
        /**
         * **Directory buckets** - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format ` <i>Bucket_name</i>.s3express-<i>az_id</i>.<i>region</i>.amazonaws.com`. Path-style requests are not supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must follow the format ` <i>bucket_base_name</i>--<i>az-id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*.
         *
         * **Access points** - When you use this action with an access point, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see [Using access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html) in the *Amazon S3 User Guide*.
         *
         * Access points and Object Lambda access points are not supported by directory buckets.
         *
         * **S3 on Outposts** - When you use this action with Amazon S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form ` <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com`. When you use this action with S3 on Outposts through the Amazon Web Services SDKs, you provide the Outposts access point ARN in place of the bucket name. For more information about S3 on Outposts ARNs, see [What is S3 on Outposts?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * `ContinuationToken` indicates to Amazon S3 that the list is being continued on this bucket with a token. `ContinuationToken` is obfuscated and is not a real key. You can use this `ContinuationToken` for pagination of the list results.
         */
        public var continuationToken: kotlin.String? = null
        /**
         * A delimiter is a character that you use to group keys.
         *
         * + **Directory buckets** - For directory buckets, `/` is the only supported delimiter.
         * + **Directory buckets ** - When you query `ListObjectsV2` with a delimiter during in-progress multipart uploads, the `CommonPrefixes` response parameter contains the prefixes that are associated with the in-progress multipart uploads. For more information about multipart uploads, see [Multipart Upload Overview](https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html) in the *Amazon S3 User Guide*.
         */
        public var delimiter: kotlin.String? = null
        /**
         * Encoding type used by Amazon S3 to encode object keys in the response. If using `url`, non-ASCII characters used in an object's key name will be URL encoded. For example, the object test_file(3).png will appear as test_file%283%29.png.
         */
        public var encodingType: aws.sdk.kotlin.services.s3.model.EncodingType? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The owner field is not present in `ListObjectsV2` by default. If you want to return the owner field with each key in the result, then set the `FetchOwner` field to `true`.
         *
         * **Directory buckets** - For directory buckets, the bucket owner is returned as the object owner for all objects.
         */
        public var fetchOwner: kotlin.Boolean? = null
        /**
         * Sets the maximum number of keys returned in the response. By default, the action returns up to 1,000 key names. The response might contain fewer keys but will never contain more.
         */
        public var maxKeys: kotlin.Int? = null
        /**
         * Specifies the optional fields that you want returned in the response. Fields that you do not specify are not returned.
         *
         * This functionality is not supported for directory buckets.
         */
        public var optionalObjectAttributes: List<OptionalObjectAttributes>? = null
        /**
         * Limits the response to keys that begin with the specified prefix.
         *
         * **Directory buckets** - For directory buckets, only prefixes that end in a delimiter (`/`) are supported.
         */
        public var prefix: kotlin.String? = null
        /**
         * Confirms that the requester knows that she or he will be charged for the list objects request in V2 style. Bucket owners need not specify this parameter in their requests.
         *
         * This functionality is not supported for directory buckets.
         */
        public var requestPayer: aws.sdk.kotlin.services.s3.model.RequestPayer? = null
        /**
         * StartAfter is where you want Amazon S3 to start listing from. Amazon S3 starts listing after this specified key. StartAfter can be any key in the bucket.
         *
         * This functionality is not supported for directory buckets.
         */
        public var startAfter: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.ListObjectsV2Request) : this() {
            this.bucket = x.bucket
            this.continuationToken = x.continuationToken
            this.delimiter = x.delimiter
            this.encodingType = x.encodingType
            this.expectedBucketOwner = x.expectedBucketOwner
            this.fetchOwner = x.fetchOwner
            this.maxKeys = x.maxKeys
            this.optionalObjectAttributes = x.optionalObjectAttributes
            this.prefix = x.prefix
            this.requestPayer = x.requestPayer
            this.startAfter = x.startAfter
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.ListObjectsV2Request = ListObjectsV2Request(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
