// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.model



public class PutBucketPolicyRequest private constructor(builder: Builder) {
    /**
     * The name of the bucket.
     *
     * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must also follow the format ` <i>bucket_base_name</i>--<i>az_id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
     */
    public val bucket: kotlin.String? = builder.bucket
    /**
     * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum-<i>algorithm</i> ` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`.
     *
     * For the `x-amz-checksum-<i>algorithm</i> ` header, replace ` <i>algorithm</i> ` with the supported algorithm from the following list:
     * + CRC32
     * + CRC32C
     * + SHA1
     * + SHA256
     *
     * For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
     *
     * If the individual checksum value you provide through `x-amz-checksum-<i>algorithm</i> ` doesn't match the checksum algorithm you set through `x-amz-sdk-checksum-algorithm`, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter and uses the checksum algorithm that matches the provided value in `x-amz-checksum-<i>algorithm</i> `.
     *
     * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
     */
    public val checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = builder.checksumAlgorithm
    /**
     * Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.
     *
     * This functionality is not supported for directory buckets.
     */
    public val confirmRemoveSelfBucketAccess: kotlin.Boolean? = builder.confirmRemoveSelfBucketAccess
    /**
     * The MD5 hash of the request body.
     *
     * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
     *
     * This functionality is not supported for directory buckets.
     */
    public val contentMd5: kotlin.String? = builder.contentMd5
    /**
     * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
     *
     * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
     */
    public val expectedBucketOwner: kotlin.String? = builder.expectedBucketOwner
    /**
     * The bucket policy as a JSON document.
     *
     * For directory buckets, the only IAM action supported in the bucket policy is `s3express:CreateSession`.
     */
    public val policy: kotlin.String? = builder.policy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBucketPolicyRequest(")
        append("bucket=$bucket,")
        append("checksumAlgorithm=$checksumAlgorithm,")
        append("confirmRemoveSelfBucketAccess=$confirmRemoveSelfBucketAccess,")
        append("contentMd5=$contentMd5,")
        append("expectedBucketOwner=$expectedBucketOwner,")
        append("policy=$policy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (checksumAlgorithm?.hashCode() ?: 0)
        result = 31 * result + (confirmRemoveSelfBucketAccess?.hashCode() ?: 0)
        result = 31 * result + (contentMd5?.hashCode() ?: 0)
        result = 31 * result + (expectedBucketOwner?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBucketPolicyRequest

        if (bucket != other.bucket) return false
        if (checksumAlgorithm != other.checksumAlgorithm) return false
        if (confirmRemoveSelfBucketAccess != other.confirmRemoveSelfBucketAccess) return false
        if (contentMd5 != other.contentMd5) return false
        if (expectedBucketOwner != other.expectedBucketOwner) return false
        if (policy != other.policy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the bucket.
         *
         * **Directory buckets ** - When you use this operation with a directory bucket, you must use path-style requests in the format `https://s3express-control.<i>region_code</i>.amazonaws.com/<i>bucket-name</i> `. Virtual-hosted-style requests aren't supported. Directory bucket names must be unique in the chosen Availability Zone. Bucket names must also follow the format ` <i>bucket_base_name</i>--<i>az_id</i>--x-s3` (for example, ` <i>DOC-EXAMPLE-BUCKET</i>--<i>usw2-az1</i>--x-s3`). For information about bucket naming restrictions, see [Directory bucket naming rules](https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html) in the *Amazon S3 User Guide*
         */
        public var bucket: kotlin.String? = null
        /**
         * Indicates the algorithm used to create the checksum for the object when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding `x-amz-checksum-<i>algorithm</i> ` or `x-amz-trailer` header sent. Otherwise, Amazon S3 fails the request with the HTTP status code `400 Bad Request`.
         *
         * For the `x-amz-checksum-<i>algorithm</i> ` header, replace ` <i>algorithm</i> ` with the supported algorithm from the following list:
         * + CRC32
         * + CRC32C
         * + SHA1
         * + SHA256
         *
         * For more information, see [Checking object integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html) in the *Amazon S3 User Guide*.
         *
         * If the individual checksum value you provide through `x-amz-checksum-<i>algorithm</i> ` doesn't match the checksum algorithm you set through `x-amz-sdk-checksum-algorithm`, Amazon S3 ignores any provided `ChecksumAlgorithm` parameter and uses the checksum algorithm that matches the provided value in `x-amz-checksum-<i>algorithm</i> `.
         *
         * For directory buckets, when you use Amazon Web Services SDKs, `CRC32` is the default checksum algorithm that's used for performance.
         */
        public var checksumAlgorithm: aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm? = null
        /**
         * Set this parameter to true to confirm that you want to remove your permissions to change this bucket policy in the future.
         *
         * This functionality is not supported for directory buckets.
         */
        public var confirmRemoveSelfBucketAccess: kotlin.Boolean? = null
        /**
         * The MD5 hash of the request body.
         *
         * For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.
         *
         * This functionality is not supported for directory buckets.
         */
        public var contentMd5: kotlin.String? = null
        /**
         * The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code `403 Forbidden` (access denied).
         *
         * For directory buckets, this header is not supported in this API operation. If you specify this header, the request fails with the HTTP status code `501 Not Implemented`.
         */
        public var expectedBucketOwner: kotlin.String? = null
        /**
         * The bucket policy as a JSON document.
         *
         * For directory buckets, the only IAM action supported in the bucket policy is `s3express:CreateSession`.
         */
        public var policy: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest) : this() {
            this.bucket = x.bucket
            this.checksumAlgorithm = x.checksumAlgorithm
            this.confirmRemoveSelfBucketAccess = x.confirmRemoveSelfBucketAccess
            this.contentMd5 = x.contentMd5
            this.expectedBucketOwner = x.expectedBucketOwner
            this.policy = x.policy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.s3.model.PutBucketPolicyRequest = PutBucketPolicyRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
