// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ExpirationStatus
import aws.sdk.kotlin.services.s3.model.LifecycleRule
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeLifecycleRuleDocument(reader: XmlTagReader): LifecycleRule {
    val builder = LifecycleRule.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Expiration com.amazonaws.s3#LifecycleRule$Expiration
            "Expiration" -> builder.expiration = deserializeLifecycleExpirationDocument(curr)
            // ID com.amazonaws.s3#LifecycleRule$ID
            "ID" -> builder.id = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ID`)" }
            // Prefix com.amazonaws.s3#LifecycleRule$Prefix
            "Prefix" -> builder.prefix = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#Prefix`)" }
            // Filter com.amazonaws.s3#LifecycleRule$Filter
            "Filter" -> builder.filter = deserializeLifecycleRuleFilterDocument(curr)
            // Status com.amazonaws.s3#LifecycleRule$Status
            "Status" -> builder.status = curr.tryData()
                .parse { ExpirationStatus.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ExpirationStatus`)" }
            // Transitions com.amazonaws.s3#LifecycleRule$Transitions
            "Transition" -> builder.transitions = run {
                val el = deserializeTransitionDocument(curr)
                createOrAppend(builder.transitions, el)
            }
            // NoncurrentVersionTransitions com.amazonaws.s3#LifecycleRule$NoncurrentVersionTransitions
            "NoncurrentVersionTransition" -> builder.noncurrentVersionTransitions = run {
                val el = deserializeNoncurrentVersionTransitionDocument(curr)
                createOrAppend(builder.noncurrentVersionTransitions, el)
            }
            // NoncurrentVersionExpiration com.amazonaws.s3#LifecycleRule$NoncurrentVersionExpiration
            "NoncurrentVersionExpiration" -> builder.noncurrentVersionExpiration = deserializeNoncurrentVersionExpirationDocument(curr)
            // AbortIncompleteMultipartUpload com.amazonaws.s3#LifecycleRule$AbortIncompleteMultipartUpload
            "AbortIncompleteMultipartUpload" -> builder.abortIncompleteMultipartUpload = deserializeAbortIncompleteMultipartUploadDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
