// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.NoncurrentVersionTransition
import aws.sdk.kotlin.services.s3.model.TransitionStorageClass
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData

internal fun deserializeNoncurrentVersionTransitionDocument(reader: XmlTagReader): NoncurrentVersionTransition {
    val builder = NoncurrentVersionTransition.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // NoncurrentDays com.amazonaws.s3#NoncurrentVersionTransition$NoncurrentDays
            "NoncurrentDays" -> builder.noncurrentDays = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#Days`)" }
            // StorageClass com.amazonaws.s3#NoncurrentVersionTransition$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { TransitionStorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#TransitionStorageClass`)" }
            // NewerNoncurrentVersions com.amazonaws.s3#NoncurrentVersionTransition$NewerNoncurrentVersions
            "NewerNoncurrentVersions" -> builder.newerNoncurrentVersions = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.s3#VersionCount`)" }
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
