// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumAlgorithm
import aws.sdk.kotlin.services.s3.model.Object
import aws.sdk.kotlin.services.s3.model.ObjectStorageClass
import aws.smithy.kotlin.runtime.collections.createOrAppend
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parse
import aws.smithy.kotlin.runtime.serde.parseLong
import aws.smithy.kotlin.runtime.serde.parseTimestamp
import aws.smithy.kotlin.runtime.serde.xml.XmlTagReader
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.time.TimestampFormat

internal fun deserializeObjectDocument(reader: XmlTagReader): Object {
    val builder = Object.Builder()

    loop@while (true) {
        val curr = reader.nextTag() ?: break@loop
        when (curr.tagName) {
            // Key com.amazonaws.s3#Object$Key
            "Key" -> builder.key = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ObjectKey`)" }
            // LastModified com.amazonaws.s3#Object$LastModified
            "LastModified" -> builder.lastModified = curr.tryData()
                .parseTimestamp(TimestampFormat.ISO_8601)
                .getOrDeserializeErr { "expected (timestamp: `com.amazonaws.s3#LastModified`)" }
            // ETag com.amazonaws.s3#Object$ETag
            "ETag" -> builder.eTag = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.s3#ETag`)" }
            // ChecksumAlgorithm com.amazonaws.s3#Object$ChecksumAlgorithm
            "ChecksumAlgorithm" -> builder.checksumAlgorithm = run {
                val el = curr.tryData()
                    .parse { ChecksumAlgorithm.fromValue(it) }
                    .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ChecksumAlgorithm`)" }
                createOrAppend(builder.checksumAlgorithm, el)
            }
            // Size com.amazonaws.s3#Object$Size
            "Size" -> builder.size = curr.tryData()
                .parseLong()
                .getOrDeserializeErr { "expected (long: `com.amazonaws.s3#Size`)" }
            // StorageClass com.amazonaws.s3#Object$StorageClass
            "StorageClass" -> builder.storageClass = curr.tryData()
                .parse { ObjectStorageClass.fromValue(it) }
                .getOrDeserializeErr { "expected (enum: `com.amazonaws.s3#ObjectStorageClass`)" }
            // Owner com.amazonaws.s3#Object$Owner
            "Owner" -> builder.owner = deserializeOwnerDocument(curr)
            // RestoreStatus com.amazonaws.s3#Object$RestoreStatus
            "RestoreStatus" -> builder.restoreStatus = deserializeRestoreStatusDocument(curr)
            else -> {}
        }
        curr.drop()
    }
    builder.correctErrors()
    return builder.build()
}
