/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.auth.awssigning;

import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAlgorithm;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningConfig;
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningResult;
import aws.smithy.kotlin.runtime.auth.awssigning.CanonicalRequest;
import aws.smithy.kotlin.runtime.auth.awssigning.Canonicalizer;
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSignerImpl;
import aws.smithy.kotlin.runtime.auth.awssigning.RequestMutator;
import aws.smithy.kotlin.runtime.auth.awssigning.SignatureCalculator;
import aws.smithy.kotlin.runtime.auth.awssigning.UnsupportedSigningAlgorithmException;
import aws.smithy.kotlin.runtime.http.Headers;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ,\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0015J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/auth/awssigning/DefaultAwsSignerImpl;", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigner;", "canonicalizer", "Laws/smithy/kotlin/runtime/auth/awssigning/Canonicalizer;", "signatureCalculator", "Laws/smithy/kotlin/runtime/auth/awssigning/SignatureCalculator;", "requestMutator", "Laws/smithy/kotlin/runtime/auth/awssigning/RequestMutator;", "(Laws/smithy/kotlin/runtime/auth/awssigning/Canonicalizer;Laws/smithy/kotlin/runtime/auth/awssigning/SignatureCalculator;Laws/smithy/kotlin/runtime/auth/awssigning/RequestMutator;)V", "sign", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningResult;", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "request", "config", "Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;", "(Laws/smithy/kotlin/runtime/http/request/HttpRequest;Laws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signChunk", "", "chunkBody", "", "prevSignature", "([B[BLaws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "signChunkTrailer", "trailingHeaders", "Laws/smithy/kotlin/runtime/http/Headers;", "(Laws/smithy/kotlin/runtime/http/Headers;[BLaws/smithy/kotlin/runtime/auth/awssigning/AwsSigningConfig;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "aws-signing-default"})
@SourceDebugExtension(value={"SMAP\nDefaultAwsSigner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAwsSigner.kt\naws/smithy/kotlin/runtime/auth/awssigning/DefaultAwsSignerImpl\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,116:1\n258#2:117\n259#2:119\n258#2:120\n259#2:122\n258#2:123\n259#2:125\n1#3:118\n1#3:121\n1#3:124\n1045#4:126\n1549#4:127\n1620#4,3:128\n2661#4,7:131\n*S KotlinDebug\n*F\n+ 1 DefaultAwsSigner.kt\naws/smithy/kotlin/runtime/auth/awssigning/DefaultAwsSignerImpl\n*L\n22#1:117\n22#1:119\n55#1:120\n55#1:122\n73#1:123\n73#1:125\n22#1:118\n55#1:121\n73#1:124\n77#1:126\n78#1:127\n78#1:128,3\n85#1:131,7\n*E\n"})
public final class DefaultAwsSignerImpl
implements AwsSigner {
    @NotNull
    private final Canonicalizer canonicalizer;
    @NotNull
    private final SignatureCalculator signatureCalculator;
    @NotNull
    private final RequestMutator requestMutator;

    public DefaultAwsSignerImpl(@NotNull Canonicalizer canonicalizer, @NotNull SignatureCalculator signatureCalculator, @NotNull RequestMutator requestMutator) {
        Intrinsics.checkNotNullParameter((Object)canonicalizer, (String)"canonicalizer");
        Intrinsics.checkNotNullParameter((Object)signatureCalculator, (String)"signatureCalculator");
        Intrinsics.checkNotNullParameter((Object)requestMutator, (String)"requestMutator");
        this.canonicalizer = canonicalizer;
        this.signatureCalculator = signatureCalculator;
        this.requestMutator = requestMutator;
    }

    public /* synthetic */ DefaultAwsSignerImpl(Canonicalizer canonicalizer, SignatureCalculator signatureCalculator, RequestMutator requestMutator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            canonicalizer = Canonicalizer.Companion.getDefault();
        }
        if ((n & 2) != 0) {
            signatureCalculator = SignatureCalculator.Companion.getDefault();
        }
        if ((n & 4) != 0) {
            requestMutator = RequestMutator.Companion.getDefault();
        }
        this(canonicalizer, signatureCalculator, requestMutator);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object sign(@NotNull HttpRequest var1_1, @NotNull AwsSigningConfig var2_2, @NotNull Continuation<? super AwsSigningResult<HttpRequest>> var3_3) {
        if (!(var3_3 instanceof sign.1)) ** GOTO lbl-1000
        var11_4 = var3_3;
        if ((var11_4.label & -2147483648) != 0) {
            var11_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ DefaultAwsSignerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.sign(null, null, (Continuation<? super AwsSigningResult<HttpRequest>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var12_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$logger$iv = $continuation.getContext();
                $i$f$logger = false;
                v0 = Reflection.getOrCreateKotlinClass(DefaultAwsSignerImpl.class).getQualifiedName();
                if (v0 == null) {
                    $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv = false;
                    $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv = "logger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv.toString());
                }
                sourceComponent$iv = v0;
                logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                if (config.getAlgorithm() != AwsSigningAlgorithm.SIGV4) {
                    throw new UnsupportedSigningAlgorithmException(config.getAlgorithm() + " support is not yet implemented for the default signer.", config.getAlgorithm());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = config;
                $continuation.L$2 = logger;
                $continuation.label = 1;
                v1 = this.canonicalizer.canonicalRequest((HttpRequest)request, config, (Continuation<? super CanonicalRequest>)$continuation);
                if (v1 == var12_6) {
                    return var12_6;
                }
                ** GOTO lbl37
            }
            case 1: {
                logger = (Logger)$continuation.L$2;
                config = (AwsSigningConfig)$continuation.L$1;
                this = (DefaultAwsSignerImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl37:
                // 2 sources

                canonical = (CanonicalRequest)v1;
                if (config.getLogRequest()) {
                    Logger.DefaultImpls.trace$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(canonical){
                        final /* synthetic */ CanonicalRequest $canonical;
                        {
                            this.$canonical = $canonical;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Canonical request:\n" + this.$canonical.getRequestString();
                        }
                    }), (int)1, null);
                }
                stringToSign = this.signatureCalculator.stringToSign(canonical.getRequestString(), config);
                Logger.DefaultImpls.trace$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(stringToSign){
                    final /* synthetic */ String $stringToSign;
                    {
                        this.$stringToSign = $stringToSign;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "String to sign:\n" + this.$stringToSign;
                    }
                }), (int)1, null);
                signingKey = this.signatureCalculator.signingKey(config);
                signature = this.signatureCalculator.calculate(signingKey, stringToSign);
                Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(signature){
                    final /* synthetic */ String $signature;
                    {
                        this.$signature = $signature;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Calculated signature: " + this.$signature;
                    }
                }), (int)1, null);
                signedRequest = this.requestMutator.appendAuth(config, canonical, signature);
                return new AwsSigningResult((Object)signedRequest, StringsKt.encodeToByteArray((String)signature));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object signChunk(@NotNull byte[] chunkBody, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config, @NotNull Continuation<? super AwsSigningResult<Unit>> $completion) {
        void $this$logger$iv;
        CoroutineContext coroutineContext = $completion.getContext();
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(DefaultAwsSignerImpl.class).getQualifiedName();
        if (string == null) {
            boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = false;
            String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        String stringToSign = this.signatureCalculator.chunkStringToSign(chunkBody, prevSignature, config);
        Logger.DefaultImpls.trace$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(stringToSign){
            final /* synthetic */ String $stringToSign;
            {
                this.$stringToSign = $stringToSign;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Chunk string to sign:\n" + this.$stringToSign;
            }
        }), (int)1, null);
        byte[] signingKey = this.signatureCalculator.signingKey(config);
        String signature = this.signatureCalculator.calculate(signingKey, stringToSign);
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(signature){
            final /* synthetic */ String $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Calculated chunk signature: " + this.$signature;
            }
        }), (int)1, null);
        return new AwsSigningResult((Object)Unit.INSTANCE, StringsKt.encodeToByteArray((String)signature));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object signChunkTrailer(@NotNull Headers trailingHeaders, @NotNull byte[] prevSignature, @NotNull AwsSigningConfig config, @NotNull Continuation<? super AwsSigningResult<Unit>> $completion) {
        void $this$reduce$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$logger$iv;
        CoroutineContext coroutineContext = $completion.getContext();
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(DefaultAwsSignerImpl.class).getQualifiedName();
        if (string == null) {
            boolean $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = false;
            String $i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException($i$a$-requireNotNull-CoroutineContextLogExtKt$logger$sourceComponent$1$iv22.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        Iterable $this$sortedBy$iv = trailingHeaders.entries();
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry e = (Map.Entry)a;
                boolean bl = false;
                String string = ((String)e.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                e = (Map.Entry)b;
                Comparable comparable = (Comparable)((Object)string);
                bl = false;
                String string2 = ((String)e.getKey()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string2)));
            }
        });
        boolean $i$f$map = false;
        sourceComponent$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void e;
            StringBuilder stringBuilder;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            StringBuilder $this$signChunkTrailer_u24lambda_u242_u24lambda_u241 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            String string2 = ((String)e.getKey()).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$signChunkTrailer_u24lambda_u242_u24lambda_u241.append(string2);
            $this$signChunkTrailer_u24lambda_u242_u24lambda_u241.append(":");
            $this$signChunkTrailer_u24lambda_u242_u24lambda_u241.append(CollectionsKt.joinToString$default((Iterable)((Iterable)e.getValue()), (CharSequence)",", null, null, (int)0, null, (Function1)signChunkTrailer.trailingHeadersBytes.2.1.1.INSTANCE, (int)30, null));
            $this$signChunkTrailer_u24lambda_u242_u24lambda_u241.append("\n");
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
            collection.add(StringsKt.encodeToByteArray((String)string3));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void bytes;
            byte[] $i$f$mapTo2 = (byte[])iterator$iv.next();
            byte[] acc = (byte[])accumulator$iv;
            boolean bl = false;
            accumulator$iv = ArraysKt.plus((byte[])acc, (byte[])bytes);
        }
        byte[] trailingHeadersBytes2 = (byte[])accumulator$iv;
        String stringToSign = this.signatureCalculator.chunkTrailerStringToSign(trailingHeadersBytes2, prevSignature, config);
        Logger.DefaultImpls.trace$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(stringToSign){
            final /* synthetic */ String $stringToSign;
            {
                this.$stringToSign = $stringToSign;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Chunk trailer string to sign:\n" + this.$stringToSign;
            }
        }), (int)1, null);
        byte[] signingKey = this.signatureCalculator.signingKey(config);
        String signature = this.signatureCalculator.calculate(signingKey, stringToSign);
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(signature){
            final /* synthetic */ String $signature;
            {
                this.$signature = $signature;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Calculated chunk signature: " + this.$signature;
            }
        }), (int)1, null);
        return new AwsSigningResult((Object)Unit.INSTANCE, StringsKt.encodeToByteArray((String)signature));
    }

    public DefaultAwsSignerImpl() {
        this(null, null, null, 7, null);
    }
}

