/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.collections;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.CaseInsensitiveMap;
import aws.smithy.kotlin.runtime.collections.ValuesMap;
import aws.smithy.kotlin.runtime.collections.ValuesMapImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010 \n\u0002\b\n\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001b\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u001c\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u0014\u0010\u0019\u001a\u00020\u00112\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017J\u001c\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017H\u0016J\u0006\u0010\u001b\u001a\u00020\u0011J\u0011\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\fH\u0086\u0002J\u001b\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u001f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\"0!0 J\u0018\u0010#\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\fH\u0086\u0002\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\"2\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010&\u001a\u00020\u0004J\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\f0 J\u0016\u0010(\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\fJ\u001b\u0010(\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010)\u001a\u00020\u0011J\u001e\u0010*\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000H\u0086\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010+\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Laws/smithy/kotlin/runtime/collections/ValuesMapBuilder;", "T", "", "caseInsensitiveName", "", "size", "", "(ZI)V", "getCaseInsensitiveName", "()Z", "values", "", "", "", "getValues", "()Ljava/util/Map;", "append", "", "name", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "appendAll", "valuesMap", "Laws/smithy/kotlin/runtime/collections/ValuesMap;", "", "appendMissing", "build", "clear", "contains", "(Ljava/lang/String;Ljava/lang/Object;)Z", "ensureListForKey", "entries", "", "", "", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "getAll", "isEmpty", "names", "remove", "removeKeysWithNoEntries", "set", "setMissing", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nValuesMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValuesMap.kt\naws/smithy/kotlin/runtime/collections/ValuesMapBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1855#2,2:182\n766#2:184\n857#2,2:185\n526#3:187\n511#3,6:188\n1#4:194\n*S KotlinDebug\n*F\n+ 1 ValuesMap.kt\naws/smithy/kotlin/runtime/collections/ValuesMapBuilder\n*L\n152#1:182,2\n161#1:184\n161#1:185,2\n167#1:187\n167#1:188,6\n*E\n"})
public class ValuesMapBuilder<T> {
    private final boolean caseInsensitiveName;
    @NotNull
    private final Map<String, List<T>> values;

    public ValuesMapBuilder(boolean caseInsensitiveName, int size) {
        this.caseInsensitiveName = caseInsensitiveName;
        this.values = this.caseInsensitiveName ? (Map)new CaseInsensitiveMap() : (Map)new LinkedHashMap(size);
    }

    public /* synthetic */ ValuesMapBuilder(boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            n = 8;
        }
        this(bl, n);
    }

    public final boolean getCaseInsensitiveName() {
        return this.caseInsensitiveName;
    }

    @NotNull
    protected final Map<String, List<T>> getValues() {
        return this.values;
    }

    @Nullable
    public final List<T> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.get(name);
    }

    public final boolean contains(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.containsKey(name);
    }

    public final boolean contains(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.values.get(name);
        return list != null ? list.contains(value) : false;
    }

    @NotNull
    public final Set<String> names() {
        return this.values.keySet();
    }

    public final boolean isEmpty() {
        return this.values.isEmpty();
    }

    @NotNull
    public final Set<Map.Entry<String, List<T>>> entries() {
        return this.values.entrySet();
    }

    public final void set(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.ensureListForKey(name, 1);
        list.clear();
        list.add(value);
    }

    public final void setMissing(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.values.containsKey(name)) {
            this.set(name, value);
        }
    }

    @Nullable
    public final T get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.getAll(name);
        return (T)(list != null ? CollectionsKt.firstOrNull(list) : null);
    }

    public final void append(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.ensureListForKey(name, 1).add(value);
    }

    public final void appendAll(@NotNull ValuesMap<T> valuesMap) {
        Intrinsics.checkNotNullParameter(valuesMap, (String)"valuesMap");
        valuesMap.forEach((Function2)new Function2<String, List<? extends T>, Unit>(this){
            final /* synthetic */ ValuesMapBuilder<T> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<? extends T> values) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.this$0.appendAll(name, (Iterable)values);
            }
        });
    }

    public final void appendMissing(@NotNull ValuesMap<T> valuesMap) {
        Intrinsics.checkNotNullParameter(valuesMap, (String)"valuesMap");
        valuesMap.forEach((Function2)new Function2<String, List<? extends T>, Unit>(this){
            final /* synthetic */ ValuesMapBuilder<T> this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<? extends T> values) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter(values, (String)"values");
                this.this$0.appendMissing(name, (Iterable)values);
            }
        });
    }

    public final void appendAll(@NotNull String name, @NotNull Iterable<? extends T> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Collection collection = values instanceof Collection ? (Collection)values : null;
        List<T> list = this.ensureListForKey(name, collection != null ? collection.size() : 2);
        boolean bl = false;
        Iterable<T> $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        Iterator<T> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            T element$iv;
            T value = element$iv = iterator.next();
            boolean bl2 = false;
            list.add(value);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void appendMissing(@NotNull String name, @NotNull Iterable<? extends T> values) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Collection<Object> collection = this.values.get(name);
        if (collection == null || (collection = CollectionsKt.toSet((Iterable)collection)) == null) {
            collection = SetsKt.emptySet();
        }
        Collection<Object> existing = collection;
        Iterable<? extends T> iterable = values;
        String string = name;
        ValuesMapBuilder valuesMapBuilder = this;
        boolean $i$f$filter = false;
        void var6_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(!existing.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        valuesMapBuilder.appendAll(string, list);
    }

    @Nullable
    public final List<T> remove(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.values.remove(name);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeKeysWithNoEntries() {
        void $this$filterTo$iv$iv;
        Map<String, List<T>> $this$filter$iv = this.values;
        boolean $i$f$filter = false;
        Map<String, List<T>> map2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((List)it.getValue()).isEmpty()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Iterator iterator2 = destination$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String k = (String)iterator2.next().getKey();
            this.remove(k);
        }
    }

    public final boolean remove(@NotNull String name, T value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<T> list = this.values.get(name);
        return list != null ? list.remove(value) : false;
    }

    public final void clear() {
        this.values.clear();
    }

    @NotNull
    public ValuesMap<T> build() {
        return new ValuesMapImpl<T>(this.caseInsensitiveName, this.values);
    }

    private final List<T> ensureListForKey(String name, int size) {
        List list = this.values.get(name);
        if (list == null) {
            ArrayList arrayList;
            ArrayList it = arrayList = new ArrayList(size);
            boolean bl = false;
            this.values.put(name, it);
            list = arrayList;
        }
        return list;
    }

    public ValuesMapBuilder() {
        this(false, 0, 3, null);
    }
}

