/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.hashing;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.hashing.Crc32;
import aws.smithy.kotlin.runtime.hashing.Crc32c;
import aws.smithy.kotlin.runtime.hashing.HashFunction;
import aws.smithy.kotlin.runtime.hashing.Md5;
import aws.smithy.kotlin.runtime.hashing.Sha1;
import aws.smithy.kotlin.runtime.hashing.Sha256;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00030\u0006j\u0002`\u0007H\u0007\u001a\u000e\u0010\b\u001a\u0004\u0018\u00010\u0003*\u00020\tH\u0007*\u001c\b\u0007\u0010\n\"\b\u0012\u0004\u0012\u00020\u00030\u00062\b\u0012\u0004\u0012\u00020\u00030\u0006B\u0002\b\u000b\u00a8\u0006\f"}, d2={"hash", "", "fn", "Laws/smithy/kotlin/runtime/hashing/HashFunction;", "input", "hashSupplier", "Lkotlin/Function0;", "Laws/smithy/kotlin/runtime/hashing/HashSupplier;", "toHashFunction", "", "HashSupplier", "Laws/smithy/kotlin/runtime/InternalApi;", "runtime-core"})
@SourceDebugExtension(value={"SMAP\nHashFunction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HashFunction.kt\naws/smithy/kotlin/runtime/hashing/HashFunctionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public final class HashFunctionKt {
    @NotNull
    public static final byte[] hash(@NotNull HashFunction fn, @NotNull byte[] input) {
        HashFunction hashFunction;
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        HashFunction $this$hash_u24lambda_u240 = hashFunction = fn;
        boolean bl = false;
        HashFunction.DefaultImpls.update$default($this$hash_u24lambda_u240, input, 0, 0, 6, null);
        return hashFunction.digest();
    }

    @InternalApi
    @NotNull
    public static final byte[] hash(@NotNull byte[] $this$hash, @NotNull HashFunction fn) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
        return HashFunctionKt.hash(fn, $this$hash);
    }

    @InternalApi
    @NotNull
    public static final byte[] hash(@NotNull byte[] $this$hash, @NotNull Function0<? extends HashFunction> hashSupplier) {
        Intrinsics.checkNotNullParameter((Object)$this$hash, (String)"<this>");
        Intrinsics.checkNotNullParameter(hashSupplier, (String)"hashSupplier");
        return HashFunctionKt.hash((HashFunction)hashSupplier.invoke(), $this$hash);
    }

    @InternalApi
    @Nullable
    public static final HashFunction toHashFunction(@NotNull String $this$toHashFunction) {
        HashFunction hashFunction;
        Intrinsics.checkNotNullParameter((Object)$this$toHashFunction, (String)"<this>");
        String string = $this$toHashFunction.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "crc32": {
                hashFunction = new Crc32();
                break;
            }
            case "crc32c": {
                hashFunction = new Crc32c();
                break;
            }
            case "sha1": {
                hashFunction = new Sha1();
                break;
            }
            case "sha256": {
                hashFunction = new Sha256();
                break;
            }
            case "md5": {
                hashFunction = new Md5();
                break;
            }
            default: {
                hashFunction = null;
            }
        }
        return hashFunction;
    }

    @InternalApi
    public static /* synthetic */ void HashSupplier$annotations() {
    }
}

