/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf;

import biz.paluch.logging.RuntimeContainer;
import biz.paluch.logging.StackTraceFilter;
import biz.paluch.logging.gelf.GelfMessageBuilder;
import biz.paluch.logging.gelf.LogEvent;
import biz.paluch.logging.gelf.LogMessageField;
import biz.paluch.logging.gelf.MessageField;
import biz.paluch.logging.gelf.PropertyProvider;
import biz.paluch.logging.gelf.StaticMessageField;
import biz.paluch.logging.gelf.Values;
import biz.paluch.logging.gelf.intern.GelfMessage;
import biz.paluch.logging.gelf.intern.HostAndPortProvider;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GelfMessageAssembler
implements HostAndPortProvider {
    private static final int MAX_SHORT_MESSAGE_LENGTH = 250;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MAX_MESSAGE_SIZE = Integer.MAX_VALUE;
    public static final String FIELD_MESSAGE_PARAM = "MessageParam";
    public static final String FIELD_STACK_TRACE = "StackTrace";
    private String host;
    private String version = "1.0";
    private String originHost;
    private int port;
    private String facility;
    private boolean extractStackTrace;
    private boolean filterStackTrace;
    private int maximumMessageSize = 8192;
    private List<MessageField> fields = new ArrayList<MessageField>();
    private Map<String, String> additionalFieldTypes = new HashMap<String, String>();
    private String timestampPattern = "yyyy-MM-dd HH:mm:ss,SSSS";

    public void initialize(PropertyProvider propertyProvider) {
        String messageSize;
        String port;
        this.host = propertyProvider.getProperty("host");
        if (this.host == null) {
            this.host = propertyProvider.getProperty("graylogHost");
        }
        if ((port = propertyProvider.getProperty("port")) == null) {
            port = propertyProvider.getProperty("graylogPort");
        }
        if (port != null && !"".equals(port)) {
            this.port = Integer.parseInt(port);
        }
        this.originHost = propertyProvider.getProperty("originHost");
        this.extractStackTrace = "true".equalsIgnoreCase(propertyProvider.getProperty("extractStackTrace"));
        this.filterStackTrace = "true".equalsIgnoreCase(propertyProvider.getProperty("filterStackTrace"));
        this.setupStaticFields(propertyProvider);
        this.setupAdditionalFieldTypes(propertyProvider);
        this.facility = propertyProvider.getProperty("facility");
        String version = propertyProvider.getProperty("version");
        if (version != null && !"".equals(version)) {
            this.version = version;
        }
        if ((messageSize = propertyProvider.getProperty("maximumMessageSize")) != null) {
            this.maximumMessageSize = Integer.parseInt(messageSize);
        }
    }

    public GelfMessage createGelfMessage(LogEvent logEvent) {
        GelfMessageBuilder builder = GelfMessageBuilder.newInstance();
        Throwable throwable = logEvent.getThrowable();
        String message = logEvent.getMessage();
        if (GelfMessage.isEmpty(message) && throwable != null) {
            message = throwable.toString();
        }
        String shortMessage = message;
        if (message.length() > 250) {
            shortMessage = message.substring(0, 249);
        }
        builder.withShortMessage(shortMessage).withFullMessage(message).withJavaTimestamp(logEvent.getLogTimestamp());
        builder.withLevel(logEvent.getSyslogLevel());
        builder.withVersion(this.getVersion());
        builder.withAdditionalFieldTypes(this.additionalFieldTypes);
        for (MessageField field : this.fields) {
            Values values = this.getValues(logEvent, field);
            if (values == null || !values.hasValues()) continue;
            for (String entryName : values.getEntryNames()) {
                String value = (String)values.getValue(entryName);
                if (value == null) continue;
                builder.withField(entryName, value);
            }
        }
        if (this.extractStackTrace && throwable != null) {
            this.addStackTrace(throwable, builder);
        }
        if (logEvent.getParameters() != null) {
            for (int i = 0; i < logEvent.getParameters().length; ++i) {
                Object param = logEvent.getParameters()[i];
                builder.withField(FIELD_MESSAGE_PARAM + i, "" + param);
            }
        }
        builder.withHost(this.getOriginHost());
        if (null != this.facility) {
            builder.withFacility(this.facility);
        }
        builder.withMaximumMessageSize(this.maximumMessageSize);
        return builder.build();
    }

    private Values getValues(LogEvent logEvent, MessageField field) {
        if (field instanceof StaticMessageField) {
            return new Values(field.getName(), this.getValue((StaticMessageField)field));
        }
        if (field instanceof LogMessageField) {
            LogMessageField logMessageField = (LogMessageField)field;
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Time) {
                SimpleDateFormat dateFormat = new SimpleDateFormat(this.timestampPattern);
                return new Values(field.getName(), dateFormat.format(new Date(logEvent.getLogTimestamp())));
            }
            if (logMessageField.getNamedLogField() == LogMessageField.NamedLogField.Server) {
                return new Values(field.getName(), this.getOriginHost());
            }
        }
        return logEvent.getValues(field);
    }

    private String getValue(StaticMessageField field) {
        return field.getValue();
    }

    private void addStackTrace(Throwable thrown, GelfMessageBuilder builder) {
        if (this.filterStackTrace) {
            builder.withField(FIELD_STACK_TRACE, StackTraceFilter.getFilteredStackTrace(thrown));
        } else {
            StringWriter sw = new StringWriter();
            thrown.printStackTrace(new PrintWriter(sw));
            builder.withField(FIELD_STACK_TRACE, sw.toString());
        }
    }

    private void setupStaticFields(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("additionalField." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                StaticMessageField field = new StaticMessageField(property.substring(0, index), property.substring(index + 1));
                this.addField(field);
            }
            ++fieldNumber;
        }
    }

    private void setupAdditionalFieldTypes(PropertyProvider propertyProvider) {
        String property;
        int fieldNumber = 0;
        while (null != (property = propertyProvider.getProperty("additionalFieldType." + fieldNumber))) {
            int index = property.indexOf(61);
            if (-1 != index) {
                String field = property.substring(0, index);
                String type = property.substring(index + 1);
                this.setAdditionalFieldType(field, type);
            }
            ++fieldNumber;
        }
    }

    public void setAdditionalFieldType(String field, String type) {
        this.additionalFieldTypes.put(field, type);
    }

    public void addField(MessageField field) {
        if (!this.fields.contains(field)) {
            this.fields.add(field);
        }
    }

    public void addFields(Collection<? extends MessageField> fields) {
        this.fields.addAll(fields);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getOriginHost() {
        if (null == this.originHost) {
            this.originHost = RuntimeContainer.FQDN_HOSTNAME;
        }
        return this.originHost;
    }

    public void setOriginHost(String originHost) {
        this.originHost = originHost;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (port > 65535 || port < 1) {
            throw new IllegalArgumentException("Invalid port number: " + port + ", supported range: 1-" + 65535);
        }
        this.port = port;
    }

    public String getFacility() {
        return this.facility;
    }

    public void setFacility(String facility) {
        this.facility = facility;
    }

    public boolean isExtractStackTrace() {
        return this.extractStackTrace;
    }

    public void setExtractStackTrace(boolean extractStackTrace) {
        this.extractStackTrace = extractStackTrace;
    }

    public boolean isFilterStackTrace() {
        return this.filterStackTrace;
    }

    public void setFilterStackTrace(boolean filterStackTrace) {
        this.filterStackTrace = filterStackTrace;
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public int getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    public void setMaximumMessageSize(int maximumMessageSize) {
        if (maximumMessageSize > Integer.MAX_VALUE || maximumMessageSize < 1) {
            throw new IllegalArgumentException("Invalid maximum message size: " + maximumMessageSize + ", supported range: 1-" + Integer.MAX_VALUE);
        }
        this.maximumMessageSize = maximumMessageSize;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        if (!"1.0".equals(version) && !"1.1".equals(version)) {
            throw new IllegalArgumentException("Invalid GELF version: " + version + ", supported range: " + "1.0" + ", " + "1.1");
        }
        this.version = version;
    }
}

