/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging.gelf.intern.sender;

import biz.paluch.logging.gelf.intern.GelfSender;
import biz.paluch.logging.gelf.intern.GelfSenderConfiguration;
import biz.paluch.logging.gelf.intern.GelfSenderProvider;
import biz.paluch.logging.gelf.intern.sender.GelfHTTPSender;
import biz.paluch.logging.gelf.intern.sender.GelfTCPSender;
import biz.paluch.logging.gelf.intern.sender.GelfUDPSender;
import biz.paluch.logging.gelf.intern.sender.UriParser;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DefaultGelfSenderProvider
implements GelfSenderProvider {
    public static final int DEFAULT_PORT = 12201;
    private static final Map<String, GelfSenderProducer> factories;
    private static final GelfSenderProducer tcpSenderFactory;
    private static final GelfSenderProducer udpSenderFactory;
    private static final GelfSenderProducer defaultSenderFactory;
    private static final GelfSenderProducer httpSenderFactory;

    @Override
    public boolean supports(String host) {
        return host != null;
    }

    @Override
    public GelfSender create(GelfSenderConfiguration configuration) throws IOException {
        String graylogHost = configuration.getHost();
        int port = configuration.getPort();
        if (port == 0) {
            port = 12201;
        }
        for (Map.Entry<String, GelfSenderProducer> entry : factories.entrySet()) {
            if (!graylogHost.startsWith(entry.getKey())) continue;
            return entry.getValue().create(configuration, graylogHost, port);
        }
        return defaultSenderFactory.create(configuration, graylogHost, port);
    }

    static {
        tcpSenderFactory = new GelfSenderProducer(){

            @Override
            public GelfSender create(GelfSenderConfiguration configuration, String host, int port) throws IOException {
                int defaultTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS);
                URI uri = URI.create(host);
                Map<String, String> params = UriParser.parse(uri);
                int connectionTimeMs = (int)UriParser.getTimeAsMs(params, "connectionTimeout", defaultTimeoutMs);
                int readTimeMs = (int)UriParser.getTimeAsMs(params, "readTimeout", defaultTimeoutMs);
                int deliveryAttempts = UriParser.getInt(params, "deliveryAttempts", 1);
                boolean keepAlive = UriParser.getString(params, "keepAlive", false);
                String tcpGraylogHost = UriParser.getHost(uri);
                return new GelfTCPSender(tcpGraylogHost, port, connectionTimeMs, readTimeMs, deliveryAttempts, keepAlive, configuration.getErrorReporter());
            }
        };
        udpSenderFactory = new GelfSenderProducer(){

            @Override
            public GelfSender create(GelfSenderConfiguration configuration, String host, int port) throws IOException {
                URI uri = URI.create(host);
                String udpGraylogHost = UriParser.getHost(uri);
                return new GelfUDPSender(udpGraylogHost, port, configuration.getErrorReporter());
            }
        };
        defaultSenderFactory = new GelfSenderProducer(){

            @Override
            public GelfSender create(GelfSenderConfiguration configuration, String host, int port) throws IOException {
                return new GelfUDPSender(host, port, configuration.getErrorReporter());
            }
        };
        httpSenderFactory = new GelfSenderProducer(){

            @Override
            public GelfSender create(GelfSenderConfiguration configuration, String host, int port) throws IOException {
                int defaultTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS);
                URL url = new URL(host);
                return new GelfHTTPSender(url, defaultTimeoutMs, defaultTimeoutMs, configuration.getErrorReporter());
            }
        };
        HashMap<String, GelfSenderProducer> prefixToFactory = new HashMap<String, GelfSenderProducer>();
        prefixToFactory.put("tcp:", tcpSenderFactory);
        prefixToFactory.put("udp:", udpSenderFactory);
        prefixToFactory.put("http", httpSenderFactory);
        factories = Collections.unmodifiableMap(prefixToFactory);
    }

    private static interface GelfSenderProducer {
        public GelfSender create(GelfSenderConfiguration var1, String var2, int var3) throws IOException;
    }
}

