/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.PasswordEncoder;
import org.jasig.cas.authentication.handler.PlainTextPasswordEncoder;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractUsernamePasswordAuthenticationHandler
implements AuthenticationHandler,
InitializingBean {
    private static final Class DEFAULT_CLASS = UsernamePasswordCredentials.class;
    private Class classToSupport;
    private boolean supportSubClasses = true;
    private PasswordEncoder passwordEncoder;
    private Log log = LogFactory.getLog(this.getClass());

    public final boolean authenticate(Credentials credentials) throws AuthenticationException {
        return this.authenticateUsernamePasswordInternal((UsernamePasswordCredentials)credentials);
    }

    protected abstract boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials var1) throws AuthenticationException;

    public final void afterPropertiesSet() throws Exception {
        if (this.passwordEncoder == null) {
            this.passwordEncoder = new PlainTextPasswordEncoder();
            this.getLog().info((Object)("No PasswordEncoder set.  Using default: " + this.passwordEncoder.getClass().getName()));
        }
        if (this.classToSupport == null) {
            this.classToSupport = DEFAULT_CLASS;
            this.getLog().info((Object)("No Class to Support set.  Using default: " + this.classToSupport.getName()));
        }
        this.afterPropertiesSetInternal();
    }

    protected void afterPropertiesSetInternal() throws Exception {
    }

    protected final PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public final Log getLog() {
        return this.log;
    }

    public final void setClassToSupport(Class classToSupport) {
        this.classToSupport = classToSupport;
    }

    public final void setSupportSubClasses(boolean supportSubClasses) {
        this.supportSubClasses = supportSubClasses;
    }

    public final void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public final boolean supports(Credentials credentials) {
        return credentials != null && (this.classToSupport.equals(credentials.getClass()) || this.classToSupport.isAssignableFrom(credentials.getClass()) && this.supportSubClasses);
    }
}

