/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.handler.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.util.UrlUtils;
import org.springframework.beans.factory.InitializingBean;

public final class HttpBasedServiceCredentialsAuthenticationHandler
implements AuthenticationHandler,
InitializingBean {
    private static final String PROTOCOL_HTTPS = "https";
    private static final int[] DEFAULT_ACCEPTABLE_CODES = new int[]{200, 304, 302, 301, 202};
    private int[] acceptableCodes;
    private final Log log = LogFactory.getLog(this.getClass());

    public boolean authenticate(Credentials credentials) {
        HttpBasedServiceCredentials serviceCredentials = (HttpBasedServiceCredentials)credentials;
        if (!serviceCredentials.getCallbackUrl().getProtocol().equals(PROTOCOL_HTTPS)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Authentication failed because url was not secure.");
            }
            return false;
        }
        this.log.debug((Object)("Attempting to resolve credentials for " + serviceCredentials));
        int response = UrlUtils.getResponseCodeFromUrl(serviceCredentials.getCallbackUrl());
        for (int i = 0; i < this.acceptableCodes.length; ++i) {
            if (response != this.acceptableCodes[i]) continue;
            return true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Authentication failed because returned status code was [" + response + "]"));
        }
        return false;
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && HttpBasedServiceCredentials.class.isAssignableFrom(credentials.getClass());
    }

    public void setAcceptableCodes(int[] acceptableCodes) {
        this.acceptableCodes = acceptableCodes;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.acceptableCodes == null) {
            this.acceptableCodes = DEFAULT_ACCEPTABLE_CODES;
        }
    }
}

