/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;

public final class UsernamePasswordCredentialsToPrincipalResolver
implements CredentialsToPrincipalResolver {
    private final Log log = LogFactory.getLog(this.getClass());

    public Principal resolvePrincipal(Credentials credentials) {
        UsernamePasswordCredentials usernamePasswordCredentials = (UsernamePasswordCredentials)credentials;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating SimplePrincipal for [" + usernamePasswordCredentials.getUsername() + "]"));
        }
        return new SimplePrincipal(usernamePasswordCredentials.getUsername());
    }

    public boolean supports(Credentials credentials) {
        return credentials != null && UsernamePasswordCredentials.class.isAssignableFrom(credentials.getClass());
    }
}

