/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.event;

import org.jasig.cas.event.AbstractEvent;
import org.jasig.cas.event.EventHandler;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

public final class EventListener
implements ApplicationListener,
InitializingBean {
    private EventHandler[] eventHandlers;

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (!AbstractEvent.class.isAssignableFrom(applicationEvent.getClass())) {
            return;
        }
        for (int i = 0; i < this.eventHandlers.length; ++i) {
            EventHandler eventHandler = this.eventHandlers[i];
            if (!eventHandler.supports(applicationEvent)) continue;
            eventHandler.handleEvent(applicationEvent);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notEmpty((Object[])this.eventHandlers, (String)"eventHandlers is a required property.");
    }

    public void setEventHandlers(EventHandler[] eventHandlers) {
        this.eventHandlers = eventHandlers;
    }
}

