/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.event;

import java.io.Serializable;
import org.jasig.cas.event.AbstractEvent;
import org.jasig.cas.ticket.Ticket;
import org.springframework.util.Assert;

public class TicketEvent
extends AbstractEvent {
    public static final TicketEventType CREATE_TICKET_GRANTING_TICKET = new TicketEventType("CREATE_TICKET_GRANTING_TICKET");
    public static final TicketEventType CREATE_SERVCE_TICKET = new TicketEventType("CREATE_SERVICE_TICKET");
    public static final TicketEventType DESTROY_TICKET_GRANTING_TICKET = new TicketEventType("DESTROY_TICKET_GRANTING_TICKET");
    public static final TicketEventType VALIDATE_SERVICE_TICKET = new TicketEventType("VALIDATE_SERVICE_TICKET");
    private static final long serialVersionUID = 3904682686680347187L;
    private final TicketEventType ticketEventType;
    private final String ticketId;

    public TicketEvent(Ticket ticket, TicketEventType ticketEventType) {
        this(ticket, ticketEventType, null);
    }

    public TicketEvent(TicketEventType ticketEventType, String ticketId) {
        this(null, ticketEventType, ticketId);
    }

    private TicketEvent(Ticket ticket, TicketEventType ticketEventType, String ticketId) {
        super(ticket == null ? ticketId : ticket);
        Assert.notNull((Object)ticketEventType);
        Assert.isTrue((ticketId != null || ticket != null ? 1 : 0) != 0);
        this.ticketId = ticket != null ? ticket.getId() : ticketId;
        this.ticketEventType = ticketEventType;
    }

    public final String getTicketId() {
        return this.ticketId;
    }

    public final Ticket getTicket() {
        return this.getSource() instanceof Ticket ? (Ticket)this.getSource() : null;
    }

    public final TicketEventType getTicketEventType() {
        return this.ticketEventType;
    }

    protected static final class TicketEventType
    implements Serializable {
        private static final long serialVersionUID = 3258689897039671865L;
        private final String name;

        protected TicketEventType(String name) {
            this.name = name;
        }

        public String getEventTypeAsString() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

