/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.event.advice;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jasig.cas.event.TicketEvent;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.util.Assert;

public class CentralAuthenticationServiceMethodInterceptor
implements MethodInterceptor,
ApplicationEventPublisherAware,
InitializingBean {
    private TicketRegistry ticketRegistry;
    private ApplicationEventPublisher applicationEventPublisher;

    public Object invoke(MethodInvocation method) throws Throwable {
        String methodName;
        Ticket ticket = null;
        TicketEvent ticketEvent = null;
        if (method.getMethod().getName().equals("validateServiceTicket")) {
            ticket = this.ticketRegistry.getTicket((String)method.getArguments()[0]);
        }
        Object returnValue = method.proceed();
        if (!method.getMethod().getName().equals("validateServiceTicket") && !method.getMethod().getName().equals("destroyTicketGrantingTicket")) {
            ticket = this.ticketRegistry.getTicket((String)returnValue);
        }
        if ((methodName = method.getMethod().getName()).equals("createTicketGrantingTicket")) {
            ticketEvent = new TicketEvent(ticket, TicketEvent.CREATE_TICKET_GRANTING_TICKET);
        } else if (methodName.equals("delegateTicketGrantingTicket")) {
            ticketEvent = new TicketEvent(ticket, TicketEvent.CREATE_TICKET_GRANTING_TICKET);
        } else if (methodName.equals("grantServiceTicket")) {
            ticketEvent = new TicketEvent(ticket, TicketEvent.CREATE_SERVCE_TICKET);
        } else if (methodName.equals("destroyTicketGrantingTicket")) {
            ticketEvent = new TicketEvent(TicketEvent.DESTROY_TICKET_GRANTING_TICKET, (String)method.getArguments()[0]);
        } else if (methodName.equals("validateServiceTicket")) {
            ticketEvent = new TicketEvent(ticket, TicketEvent.VALIDATE_SERVICE_TICKET);
        }
        if (ticketEvent != null) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)ticketEvent);
        }
        return returnValue;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketRegistry, (String)"ticketRegistry is a required property.");
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

