/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.web.util.SecureCookieGenerator;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;

public final class LogoutController
extends AbstractController
implements InitializingBean {
    private CentralAuthenticationService centralAuthenticationService;
    private SecureCookieGenerator ticketGrantingTicketCookieGenerator;
    private SecureCookieGenerator warnCookieGenerator;
    private String logoutView;
    private boolean followServiceRedirects;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.centralAuthenticationService, (String)("centralAuthenticationService must be set on " + ((Object)((Object)this)).getClass().getName()));
        Assert.notNull((Object)((Object)this.ticketGrantingTicketCookieGenerator));
        Assert.notNull((Object)((Object)this.warnCookieGenerator));
        Assert.hasText((String)this.logoutView);
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticketGrantingTicketId = this.ticketGrantingTicketCookieGenerator.getCookieValue(request);
        String service = request.getParameter("service");
        if (ticketGrantingTicketId != null) {
            this.centralAuthenticationService.destroyTicketGrantingTicket(ticketGrantingTicketId);
            this.ticketGrantingTicketCookieGenerator.removeCookie(response);
            this.warnCookieGenerator.removeCookie(response);
        }
        if (this.followServiceRedirects && service != null) {
            return new ModelAndView((View)new RedirectView(service));
        }
        return new ModelAndView(this.logoutView, "url", (Object)request.getParameter("url"));
    }

    public void setTicketGrantingTicketCookieGenerator(SecureCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public void setWarnCookieGenerator(SecureCookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    public void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public void setFollowServiceRedirects(boolean followServiceRedirects) {
        this.followServiceRedirects = followServiceRedirects;
    }

    public void setLogoutView(String logoutView) {
        this.logoutView = logoutView;
    }
}

