/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import javax.servlet.http.HttpServletRequest;
import org.jasig.cas.web.flow.util.ContextUtils;
import org.jasig.cas.web.util.SecureCookieGenerator;
import org.jasig.cas.web.util.WebUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.Event;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.action.AbstractAction;

public abstract class AbstractLoginAction
extends AbstractAction {
    private static final String EVENT_AUTHENTICATION_REQUIRED = "authenticationRequired";
    private static final String EVENT_AUTHENTICATED_BUT_NO_SERVICE = "authenticatedButNoService";
    private static final String EVENT_GATEWAY = "gateway";
    private static final String EVENT_HAS_SERVICE = "hasService";
    private static final String EVENT_REDIRECT = "redirect";
    public static final String REQUEST_PARAM_GATEWAY = "gateway";
    public static final String REQUEST_ATTRIBUTE_TICKET_GRANTING_TICKET = "ticketGrantingTicketId";
    private SecureCookieGenerator ticketGrantingTicketCookieGenerator;
    private SecureCookieGenerator warnCookieGenerator;

    protected final Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = ContextUtils.getHttpServletRequest(context);
        String ticketGrantingTicketId = this.ticketGrantingTicketCookieGenerator.getCookieValue(request);
        String service = WebUtils.getRequestParameterAsString(request, "service");
        boolean gateway = WebUtils.getRequestParameterAsBoolean(request, "gateway");
        boolean renew = WebUtils.getRequestParameterAsBoolean(request, "renew");
        boolean warn = Boolean.valueOf(this.warnCookieGenerator.getCookieValue(request));
        return this.doExecuteInternal(context, ticketGrantingTicketId, service, gateway, renew, warn);
    }

    protected final Event authenticationRequired() {
        return this.result(EVENT_AUTHENTICATION_REQUIRED);
    }

    protected final Event authenticatedButNoService() {
        return this.result(EVENT_AUTHENTICATED_BUT_NO_SERVICE);
    }

    protected final Event gateway() {
        return this.result("gateway");
    }

    protected final Event hasService() {
        return this.result(EVENT_HAS_SERVICE);
    }

    protected final Event redirect() {
        return this.result(EVENT_REDIRECT);
    }

    protected abstract Event doExecuteInternal(RequestContext var1, String var2, String var3, boolean var4, boolean var5, boolean var6);

    protected final void initAction() {
        Assert.notNull((Object)((Object)this.ticketGrantingTicketCookieGenerator));
        Assert.notNull((Object)((Object)this.warnCookieGenerator));
        this.initActionInternal();
    }

    public final void setTicketGrantingTicketCookieGenerator(SecureCookieGenerator ticketGrantingTicketCookieGenerator) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
    }

    public final void setWarnCookieGenerator(SecureCookieGenerator warnCookieGenerator) {
        this.warnCookieGenerator = warnCookieGenerator;
    }

    protected final SecureCookieGenerator getTicketGrantingTicketCookieGenerator() {
        return this.ticketGrantingTicketCookieGenerator;
    }

    protected void initActionInternal() {
    }
}

