/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.AccountEnvelope;
import co.kuali.bai.v2.domain.FileEnvelope;
import co.kuali.bai.v2.domain.GroupEnvelope;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.domain.Transaction;
import co.kuali.bai.v2.record.account.AccountIdentifierAndSummaryStatusRecord;
import co.kuali.bai.v2.record.account.AccountTrailerRecord;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import co.kuali.bai.v2.record.file.FileHeaderRecord;
import co.kuali.bai.v2.record.file.FileTrailerRecord;
import co.kuali.bai.v2.record.group.GroupHeaderRecord;
import co.kuali.bai.v2.record.group.GroupTrailerRecord;
import co.kuali.bai.v2.record.transaction.TransactionDetailRecord;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Deque;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class Parser {
    private static final int MINIMUM_NUMBER_OF_RECORDS = 6;
    private static final ContinuationRecord[] EMPTY_CONTINUATION_RECORD_ARRAY = new ContinuationRecord[0];

    private Parser() {
    }

    public static FileEnvelope parse(Path file) {
        ArrayDeque<String> records;
        try {
            records = new ArrayDeque<String>(Files.readAllLines(file));
        }
        catch (IOException e) {
            throw new Bai2ParseException("Error parsing file", e);
        }
        return Parser.parse(records);
    }

    public static FileEnvelope parse(Deque<String> records) {
        int totalRecordCount = records.size();
        if (totalRecordCount < 6) {
            throw new Bai2ParseException("Invalid file format; there must be at least 6 records to be a valid BAI2 file");
        }
        try {
            FileEnvelope fileEnvelope = Parser.createFileEnvelope(records);
            if (records.stream().anyMatch(StringUtils::isNotBlank)) {
                throw new Bai2ParseException("Invalid file format; expected EOF but found additional records");
            }
            return fileEnvelope;
        }
        catch (Bai2ParseException | NoSuchElementException e) {
            int exceptionLineNumber = totalRecordCount - records.size();
            throw new Bai2ParseException("There was an error parsing the record on line %s (if it is continued, the error could actually be in one of the continuation records".formatted(exceptionLineNumber), e);
        }
    }

    private static FileEnvelope createFileEnvelope(Deque<String> records) {
        String fileHeader = records.pop();
        ContinuationRecord[] fileHeaderContinuationRecords = Parser.createContinuation(records);
        FileHeaderRecord fileHeaderRecord = FileHeaderRecord.create(fileHeader, fileHeaderContinuationRecords);
        List<GroupEnvelope> groupEnvelopes = Parser.createGroupEnvelops(records);
        String fileTrailer = records.pop();
        FileTrailerRecord fileTrailerRecord = FileTrailerRecord.create(fileTrailer, new ContinuationRecord[0]);
        return new FileEnvelope(fileHeaderRecord, groupEnvelopes, fileTrailerRecord);
    }

    private static List<GroupEnvelope> createGroupEnvelops(Deque<String> records) {
        ArrayList<GroupEnvelope> groupEnvelopes = new ArrayList<GroupEnvelope>();
        String nextRecord = records.peek();
        while (RecordCode.GROUP_HEADER == Parser.extractRecordCode(nextRecord)) {
            nextRecord = records.pop();
            ContinuationRecord[] groupHeaderContinuationRecords = Parser.createContinuation(records);
            GroupHeaderRecord groupHeaderRecord = GroupHeaderRecord.create(nextRecord, groupHeaderContinuationRecords);
            Currency groupCurrency = Optional.ofNullable(groupHeaderRecord.getCurrency()).orElse(Currency.getInstance("USD"));
            List<AccountEnvelope> accountEnvelopes = Parser.createAccountEnvelopesForGroup(records, groupCurrency);
            String groupTrailer = records.pop();
            ContinuationRecord[] groupTrailerContinuationRecords = Parser.createContinuation(records);
            GroupTrailerRecord groupTrailerRecord = GroupTrailerRecord.create(groupTrailer, groupTrailerContinuationRecords);
            GroupEnvelope groupEnvelope = new GroupEnvelope(groupHeaderRecord, accountEnvelopes, groupTrailerRecord, groupCurrency);
            groupEnvelopes.add(groupEnvelope);
            nextRecord = records.peek();
        }
        if (nextRecord == null) {
            throw new Bai2ParseException("Invalid file format; expected a FILE_TRAILER record but found EOF");
        }
        return groupEnvelopes;
    }

    private static List<AccountEnvelope> createAccountEnvelopesForGroup(Deque<String> records, Currency groupCurrency) {
        ArrayList<AccountEnvelope> accountEnvelopes = new ArrayList<AccountEnvelope>();
        String nextRecord = records.peek();
        while (RecordCode.ACCOUNT_IDENTIFIER == Parser.extractRecordCode(nextRecord)) {
            nextRecord = records.pop();
            ContinuationRecord[] accountHeaderContinuationRecords = Parser.createContinuation(records);
            AccountIdentifierAndSummaryStatusRecord accountIdentifierAndSummaryStatusRecord = AccountIdentifierAndSummaryStatusRecord.create(nextRecord, accountHeaderContinuationRecords);
            List<Transaction> transactions = Parser.createTransactionsForAccount(records, groupCurrency);
            String accountTrailer = records.pop();
            ContinuationRecord[] accountTrailerContinuationRecords = Parser.createContinuation(records);
            AccountTrailerRecord accountTrailerRecord = AccountTrailerRecord.create(accountTrailer, accountTrailerContinuationRecords);
            Currency accountCurrency = Optional.ofNullable(accountIdentifierAndSummaryStatusRecord.getCurrency()).orElse(groupCurrency);
            AccountEnvelope accountEnvelope = new AccountEnvelope(accountIdentifierAndSummaryStatusRecord, transactions, accountTrailerRecord, accountCurrency);
            accountEnvelopes.add(accountEnvelope);
            nextRecord = records.peek();
        }
        if (nextRecord == null) {
            throw new Bai2ParseException("Invalid file format; expected an GROUP_TRAILER record but found EOF");
        }
        return accountEnvelopes;
    }

    private static List<Transaction> createTransactionsForAccount(Deque<String> records, Currency currency) {
        ArrayList<Transaction> transactions = new ArrayList<Transaction>();
        String nextRecord = records.peek();
        while (RecordCode.TRANSACTION_DETAIL == Parser.extractRecordCode(nextRecord)) {
            nextRecord = records.pop();
            ContinuationRecord[] transactionDetailContinuationRecords = Parser.createContinuation(records);
            TransactionDetailRecord transactionDetailRecord = TransactionDetailRecord.create(nextRecord, transactionDetailContinuationRecords);
            Transaction transaction = new Transaction(transactionDetailRecord, currency);
            transactions.add(transaction);
            nextRecord = records.peek();
        }
        if (nextRecord == null) {
            throw new Bai2ParseException("Invalid file format; expected an ACCOUNT_TRAILER record but found EOF");
        }
        return transactions;
    }

    private static ContinuationRecord[] createContinuation(Deque<String> records) {
        ArrayList<ContinuationRecord> continuationRecords = new ArrayList<ContinuationRecord>();
        String nextRecord = records.peek();
        while (RecordCode.CONTINUATION == Parser.extractRecordCode(nextRecord)) {
            nextRecord = records.pop();
            ContinuationRecord continuationRecord = ContinuationRecord.create(nextRecord);
            continuationRecords.add(continuationRecord);
            nextRecord = records.peek();
        }
        if (nextRecord == null) {
            throw new Bai2ParseException("Invalid file format; expected another record but found EOF");
        }
        return continuationRecords.toArray(EMPTY_CONTINUATION_RECORD_ARRAY);
    }

    private static @Nullable RecordCode extractRecordCode(@Nullable String record) {
        if (StringUtils.isBlank((CharSequence)record)) {
            return null;
        }
        String recordCode = record.substring(0, 2);
        return RecordCode.get(recordCode);
    }
}

