/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.Envelope;
import co.kuali.bai.v2.domain.Transaction;
import co.kuali.bai.v2.domain.TypeCode;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailabilityFactory;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.account.AccountIdentifierAndSummaryStatusRecord;
import co.kuali.bai.v2.record.account.AccountTrailerRecord;
import java.util.ArrayList;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public final class AccountEnvelope
implements Envelope<Transaction> {
    private final AccountIdentifierAndSummaryStatusRecord accountIdentifer;
    private final List<Status> statuses = new ArrayList<Status>();
    private final List<Summary> summaries = new ArrayList<Summary>();
    private final List<Transaction> transactions;
    private final AccountTrailerRecord accountTrailer;
    private final Currency currency;
    private final int processedRecords;

    public AccountEnvelope(AccountIdentifierAndSummaryStatusRecord accountIdentifer, List<Transaction> transactions, AccountTrailerRecord accountTrailer, Currency currency) {
        Validate.isTrue((accountIdentifer != null ? 1 : 0) != 0, (String)"AccountIdentifier cannot be null", (Object[])new Object[0]);
        Validate.isTrue((transactions != null ? 1 : 0) != 0, (String)"Transactions list cannot be null", (Object[])new Object[0]);
        Validate.isTrue((accountTrailer != null ? 1 : 0) != 0, (String)"AccountTrailer cannot be null", (Object[])new Object[0]);
        Validate.isTrue((currency != null ? 1 : 0) != 0, (String)"Currency cannot be null", (Object[])new Object[0]);
        this.accountIdentifer = accountIdentifer;
        this.transactions = List.copyOf(transactions);
        this.accountTrailer = accountTrailer;
        this.currency = currency;
        this.statuses.addAll(AccountEnvelope.extractStatuses(accountIdentifer.getSummaryOrStatuses(), this.currency));
        this.summaries.addAll(AccountEnvelope.extractSummaries(accountIdentifer.getSummaryOrStatuses(), this.currency));
        this.processedRecords = accountIdentifer.getRecordCount() + transactions.stream().mapToInt(Transaction::getRecordCount).sum() + accountTrailer.getRecordCount();
        this.validate(this.processedRecords);
    }

    private static List<Status> extractStatuses(List<AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus> summariesOrStatuses, Currency currency) {
        return summariesOrStatuses.stream().filter(sos -> sos.getTypeCode().isStatus()).map(sos -> new Status((AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus)sos, currency)).collect(Collectors.toList());
    }

    private static List<Summary> extractSummaries(List<AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus> summariesOrStatuses, Currency currency) {
        return summariesOrStatuses.stream().filter(sos -> sos.getTypeCode().isSummary()).map(sos -> new Summary((AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus)sos, currency)).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccountEnvelope)) {
            return false;
        }
        AccountEnvelope that = (AccountEnvelope)obj;
        return Objects.equals(this.accountIdentifer, that.accountIdentifer) && Objects.equals(this.transactions, that.transactions) && Objects.equals(this.accountTrailer, that.accountTrailer);
    }

    public int hashCode() {
        return Objects.hash(this.accountIdentifer, this.transactions, this.accountTrailer);
    }

    public String toString() {
        return "AccountEnvelope{accountIdentifer=" + String.valueOf(this.accountIdentifer) + ", statuses=" + String.valueOf(this.statuses) + ", summaries=" + String.valueOf(this.summaries) + ", transactions=" + String.valueOf(this.transactions) + ", accountTrailer=" + String.valueOf(this.accountTrailer) + ", currency=" + String.valueOf(this.currency) + "}";
    }

    public String getCustomerAccountNumber() {
        return this.accountIdentifer.getCustomerAccountNumber();
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public List<Status> getStatuses() {
        return List.copyOf(this.statuses);
    }

    public List<Summary> getSummaries() {
        return List.copyOf(this.summaries);
    }

    public double getAccountControlTotal() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.accountTrailer.getAccountControlTotal(), this.currency);
    }

    @Override
    public List<Transaction> getContents() {
        return List.copyOf(this.transactions);
    }

    public int getProcessedRecords() {
        return this.processedRecords;
    }

    private void validate(int processedRecords) {
        if (this.accountTrailer.getNumberOfRecords() != processedRecords) {
            throw new Bai2ParseException("Invalid file format; the number of records in Account Envelope does not match the expected count: Expected " + this.accountTrailer.getNumberOfRecords() + " but found " + processedRecords);
        }
    }

    public static final class Summary {
        private final TypeCode typeCode;
        private final @Nullable Double amount;
        private final @Nullable Integer itemCount;
        private final @Nullable FundsAvailability fundsAvailability;

        private Summary(AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus summaryOrStatus, Currency currency) {
            this.typeCode = summaryOrStatus.getTypeCode();
            this.amount = Optional.ofNullable(summaryOrStatus.getAmount()).map(l -> ValueUtils.convertLongToDoubleWithCurrency(l, currency)).orElse(null);
            this.itemCount = summaryOrStatus.getItemCount();
            this.fundsAvailability = Optional.ofNullable(summaryOrStatus.getFundsAvailabilitySubRecord()).map(subRecord -> FundsAvailabilityFactory.create(subRecord, currency)).orElse(null);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Summary)) {
                return false;
            }
            Summary summary = (Summary)obj;
            return this.typeCode == summary.typeCode && Objects.equals(this.amount, summary.amount) && Objects.equals(this.itemCount, summary.itemCount) && Objects.equals(this.fundsAvailability, summary.fundsAvailability);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.typeCode, this.amount, this.itemCount, this.fundsAvailability});
        }

        public String toString() {
            return "Summary{typeCode=" + String.valueOf((Object)this.typeCode) + ", amount=" + this.amount + ", itemCount=" + this.itemCount + ", fundsAvailability=" + String.valueOf(this.fundsAvailability) + "}";
        }

        public TypeCode getTypeCode() {
            return this.typeCode;
        }

        public Optional<Double> getAmount() {
            return Optional.ofNullable(this.amount);
        }

        public Optional<Integer> getItemCount() {
            return Optional.ofNullable(this.itemCount);
        }

        public Optional<FundsAvailability> getFundsAvailability() {
            return Optional.ofNullable(this.fundsAvailability);
        }
    }

    public static final class Status {
        private final TypeCode typeCode;
        private final @Nullable Double amount;

        private Status(AccountIdentifierAndSummaryStatusRecord.SummaryOrStatus summaryOrStatus, Currency currency) {
            this.typeCode = summaryOrStatus.getTypeCode();
            this.amount = Optional.ofNullable(summaryOrStatus.getAmount()).map(l -> ValueUtils.convertLongToDoubleWithCurrency(l, currency)).orElse(null);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Status)) {
                return false;
            }
            Status status = (Status)obj;
            return this.typeCode == status.typeCode && Objects.equals(this.amount, status.amount);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.typeCode, this.amount});
        }

        public String toString() {
            return "Status{typeCode=" + String.valueOf((Object)this.typeCode) + ", amount=" + this.amount + "}";
        }

        public TypeCode getTypeCode() {
            return this.typeCode;
        }

        public Optional<Double> getAmount() {
            return Optional.ofNullable(this.amount);
        }
    }
}

