/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.Envelope;
import co.kuali.bai.v2.domain.GroupEnvelope;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.file.FileHeaderRecord;
import co.kuali.bai.v2.record.file.FileTrailerRecord;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public final class FileEnvelope
implements Envelope<GroupEnvelope> {
    private final FileHeaderRecord fileHeader;
    private final List<GroupEnvelope> groupEnvelopes;
    private final FileTrailerRecord fileTrailer;

    public FileEnvelope(FileHeaderRecord fileHeader, List<GroupEnvelope> groupEnvelopes, FileTrailerRecord fileTrailer) {
        Validate.isTrue((fileHeader != null ? 1 : 0) != 0, (String)"FileHeader cannot be null", (Object[])new Object[0]);
        Validate.isTrue((groupEnvelopes != null ? 1 : 0) != 0, (String)"GroupEnvelopes list cannot be null", (Object[])new Object[0]);
        Validate.isTrue((fileTrailer != null ? 1 : 0) != 0, (String)"FileTrailer cannot be null", (Object[])new Object[0]);
        this.fileHeader = fileHeader;
        this.groupEnvelopes = List.copyOf(groupEnvelopes);
        this.fileTrailer = fileTrailer;
        long localProcessedRecords = (long)fileHeader.getRecordCount() + groupEnvelopes.stream().mapToLong(GroupEnvelope::getProcessedRecords).sum() + (long)fileTrailer.getRecordCount();
        this.validate(localProcessedRecords);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FileEnvelope)) {
            return false;
        }
        FileEnvelope that = (FileEnvelope)obj;
        return Objects.equals(this.fileHeader, that.fileHeader) && Objects.equals(this.groupEnvelopes, that.groupEnvelopes) && Objects.equals(this.fileTrailer, that.fileTrailer);
    }

    public int hashCode() {
        return Objects.hash(this.fileHeader, this.groupEnvelopes, this.fileTrailer);
    }

    public String toString() {
        return "FileEnvelope{fileHeader=" + String.valueOf(this.fileHeader) + ", groupEnvelopes=" + String.valueOf(this.groupEnvelopes) + ", fileTrailer=" + String.valueOf(this.fileTrailer) + "}";
    }

    public String getSenderIdentification() {
        return this.fileHeader.getSenderIdentification();
    }

    public String getReceiverIdentification() {
        return this.fileHeader.getReceiverIdentification();
    }

    public LocalDate getCreationDate() {
        return this.fileHeader.getCreationDate();
    }

    public LocalTime getCreationTime() {
        return this.fileHeader.getCreationTime();
    }

    public int getFileIdentificationNumber() {
        return this.fileHeader.getFileIdentificationNumber();
    }

    public double getFileControlTotal() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.fileTrailer.getFileControlTotal(), Currency.getInstance("USD"));
    }

    @Override
    public List<GroupEnvelope> getContents() {
        return List.copyOf(this.groupEnvelopes);
    }

    private void validate(long processedRecords) {
        if (this.fileTrailer.getNumberOfGroups() != (long)this.getContents().size()) {
            throw new Bai2ParseException("Invalid file format; the number of groups in File Envelope does not match the expected count: Expected " + this.fileTrailer.getNumberOfGroups() + " but found " + this.getContents().size());
        }
        if (this.fileTrailer.getNumberOfRecords() != processedRecords) {
            throw new Bai2ParseException("Invalid file format; the number of records in File Envelope does not match the expected count: Expected " + this.fileTrailer.getNumberOfRecords() + " but found " + processedRecords);
        }
    }
}

