/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.domain.AccountEnvelope;
import co.kuali.bai.v2.domain.AsOfDateModifier;
import co.kuali.bai.v2.domain.Envelope;
import co.kuali.bai.v2.domain.GroupStatus;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.group.GroupHeaderRecord;
import co.kuali.bai.v2.record.group.GroupTrailerRecord;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Currency;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public final class GroupEnvelope
implements Envelope<AccountEnvelope> {
    private final GroupHeaderRecord groupHeader;
    private final List<AccountEnvelope> accountEnvelopes;
    private final GroupTrailerRecord groupTrailer;
    private final Currency currency;
    private final int processedRecords;

    public GroupEnvelope(GroupHeaderRecord groupHeader, List<AccountEnvelope> accountEnvelopes, GroupTrailerRecord groupTrailer, Currency currency) {
        Validate.isTrue((groupHeader != null ? 1 : 0) != 0, (String)"GroupHeader cannot be null", (Object[])new Object[0]);
        Validate.isTrue((accountEnvelopes != null ? 1 : 0) != 0, (String)"AccountEnvelopes list cannot be null", (Object[])new Object[0]);
        Validate.isTrue((groupTrailer != null ? 1 : 0) != 0, (String)"GroupTrailer cannot be null", (Object[])new Object[0]);
        Validate.isTrue((currency != null ? 1 : 0) != 0, (String)"Currency cannot be null", (Object[])new Object[0]);
        this.groupHeader = groupHeader;
        this.accountEnvelopes = List.copyOf(accountEnvelopes);
        this.groupTrailer = groupTrailer;
        this.currency = currency;
        this.processedRecords = groupHeader.getRecordCount() + accountEnvelopes.stream().mapToInt(AccountEnvelope::getProcessedRecords).sum() + groupTrailer.getRecordCount();
        this.validate(this.processedRecords);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GroupEnvelope)) {
            return false;
        }
        GroupEnvelope that = (GroupEnvelope)obj;
        return Objects.equals(this.groupHeader, that.groupHeader) && Objects.equals(this.accountEnvelopes, that.accountEnvelopes) && Objects.equals(this.groupTrailer, that.groupTrailer);
    }

    public int hashCode() {
        return Objects.hash(this.groupHeader, this.accountEnvelopes, this.groupTrailer);
    }

    public String toString() {
        return "GroupEnvelope{groupHeader=" + String.valueOf(this.groupHeader) + ", accountEnvelopes=" + String.valueOf(this.accountEnvelopes) + ", groupTrailer=" + String.valueOf(this.groupTrailer) + ", currency=" + String.valueOf(this.currency) + "}";
    }

    public @Nullable String getUltimateReceiverIdentification() {
        return this.groupHeader.getUltimateReceiverIdentification();
    }

    public String getOriginatorIdentification() {
        return this.groupHeader.getOriginatorIdentification();
    }

    public GroupStatus getGroupStatus() {
        return this.groupHeader.getGroupStatus();
    }

    public LocalDate getAsOfDate() {
        return this.groupHeader.getAsOfDate();
    }

    public Optional<LocalTime> getAsOfTime() {
        return Optional.ofNullable(this.groupHeader.getAsOfTime());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Optional<AsOfDateModifier> getAsOfDateModifier() {
        return Optional.ofNullable(this.groupHeader.getAsOfDateModifier());
    }

    public double getGroupControlTotal() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.groupTrailer.getGroupControlTotal(), this.currency);
    }

    @Override
    public List<AccountEnvelope> getContents() {
        return List.copyOf(this.accountEnvelopes);
    }

    public int getProcessedRecords() {
        return this.processedRecords;
    }

    private void validate(long processedRecords) {
        if (this.groupTrailer.getNumberOfAccounts() != this.getContents().size()) {
            throw new Bai2ParseException("Invalid file format; the number of accounts in Group Envelope does not match the expected count: Expected " + this.groupTrailer.getNumberOfAccounts() + " but found " + this.getContents().size());
        }
        if ((long)this.groupTrailer.getNumberOfRecords() != processedRecords) {
            throw new Bai2ParseException("Invalid file format; the number of records in Group Envelope does not match the expected count: Expected " + this.groupTrailer.getNumberOfRecords() + " but found " + processedRecords);
        }
    }
}

