/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain;

import co.kuali.bai.v2.domain.TypeCode;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailabilityFactory;
import co.kuali.bai.v2.record.transaction.TransactionDetailRecord;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public final class Transaction {
    private final TransactionDetailRecord transactionDetailRecord;
    private final @Nullable FundsAvailability fundsAvailability;
    private final Currency currency;

    public Transaction(TransactionDetailRecord transactionDetailRecord, Currency currency) {
        Validate.isTrue((transactionDetailRecord != null ? 1 : 0) != 0, (String)"TransactionDetailRecord cannot be null", (Object[])new Object[0]);
        Validate.isTrue((currency != null ? 1 : 0) != 0, (String)"Currency cannot be null", (Object[])new Object[0]);
        this.transactionDetailRecord = transactionDetailRecord;
        this.currency = currency;
        this.fundsAvailability = Optional.ofNullable(transactionDetailRecord.getFundsAvailability()).map(subRecord -> FundsAvailabilityFactory.create(subRecord, currency)).orElse(null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Transaction)) {
            return false;
        }
        Transaction that = (Transaction)obj;
        return Objects.equals(this.transactionDetailRecord, that.transactionDetailRecord);
    }

    public int hashCode() {
        return Objects.hashCode(this.transactionDetailRecord);
    }

    public String toString() {
        return "Transaction{transactionDetailRecord=" + String.valueOf(this.transactionDetailRecord) + "}";
    }

    public TypeCode getTypeCode() {
        return this.transactionDetailRecord.getTypeCode();
    }

    public Optional<Double> getAmount() {
        return Optional.ofNullable(this.transactionDetailRecord.getAmount()).map(BigDecimal::valueOf).map(amount -> amount.movePointLeft(this.currency.getDefaultFractionDigits()).doubleValue());
    }

    public Optional<FundsAvailability> getFundsAvailability() {
        return Optional.ofNullable(this.fundsAvailability);
    }

    public Optional<String> getBankReferenceNumber() {
        return Optional.ofNullable(this.transactionDetailRecord.getBankReferenceNumber());
    }

    public Optional<String> getCustomerReferenceNumber() {
        return Optional.ofNullable(this.transactionDetailRecord.getCustomerReferenceNumber());
    }

    public Optional<String> getText() {
        return Optional.ofNullable(this.transactionDetailRecord.getText());
    }

    public int getRecordCount() {
        return this.transactionDetailRecord.getRecordCount();
    }
}

