/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain;

import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.TransactionType;
import co.kuali.bai.v2.domain.TypeCodeUsage;

public enum TypeCode {
    OPENING_LEDGER("010", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_OPENING_LEDGER_MTD("011", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_OPENING_LEDGER_YTD("012", TransactionType.NA, TypeCodeUsage.STATUS),
    CLOSING_LEDGER("015", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_LEDGER_MTD("020", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_LEDGER_PREVIOUS_MONTH("021", TransactionType.NA, TypeCodeUsage.STATUS),
    AGGREGATE_BALANCE_ADJUSTMENTS("022", TransactionType.NA, TypeCodeUsage.STATUS),
    AGGREGATE_CLOSING_LEDGER_YTD_PREVIOUS_MONTH("024", TransactionType.NA, TypeCodeUsage.STATUS),
    AGGREGATE_CLOSING_LEDGER_YTD_PREVIOUS("025", TransactionType.NA, TypeCodeUsage.STATUS),
    CURRENT_LEDGER("030", TransactionType.NA, TypeCodeUsage.STATUS),
    ACH_NET_POSITION("037", TransactionType.NA, TypeCodeUsage.STATUS),
    OPENING_AVAILABLE_PLUS_TOTAL_SAME_DAY_ACH_DTC_DEPOSIT("039", TransactionType.NA, TypeCodeUsage.STATUS),
    OPENING_AVAILABLE("040", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_OPENING_AVAILABLE_MTD("041", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_OPENING_AVAILABLE_YTD("042", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_AVAILABLE_PREVIOUS_MONTH("043", TransactionType.NA, TypeCodeUsage.STATUS),
    DISPERSING_OPENING_AVAILABLE_BALANCE("044", TransactionType.NA, TypeCodeUsage.STATUS),
    CLOSING_AVAILABLE("045", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_AVAILABLE_MTD("050", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_AVAILABLE_LAST_MONTH("051", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_AVAILABLE_YTD_LAST_MONTH("054", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CLOSING_AVAILABLE_YTD("055", TransactionType.NA, TypeCodeUsage.STATUS),
    LOAN_BALANCE("056", TransactionType.NA, TypeCodeUsage.STATUS),
    TOTAL_INVESTMENT_POSITION("057", TransactionType.NA, TypeCodeUsage.STATUS),
    CURRENT_AVAILABLE_CRS_SUPPRESSED("059", TransactionType.NA, TypeCodeUsage.STATUS),
    CURRENT_AVAILABLE("060", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CURRENT_AVAILABLE_MTD("061", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_CURRENT_AVAILABLE_YTD("062", TransactionType.NA, TypeCodeUsage.STATUS),
    TOTAL_FLOAT("063", TransactionType.NA, TypeCodeUsage.STATUS),
    TARGET_BALANCE("065", TransactionType.NA, TypeCodeUsage.STATUS),
    ADJUSTED_BALANCE("066", TransactionType.NA, TypeCodeUsage.STATUS),
    ADJUSTED_BALANCE_MTD("067", TransactionType.NA, TypeCodeUsage.STATUS),
    ADJUSTED_BALANCE_YTD("068", TransactionType.NA, TypeCodeUsage.STATUS),
    ZERO_DAY_FLOAT("070", TransactionType.NA, TypeCodeUsage.STATUS),
    ONE_DAY_FLOAT("072", TransactionType.NA, TypeCodeUsage.STATUS),
    FLOAT_ADJUSTMENT("073", TransactionType.NA, TypeCodeUsage.STATUS),
    TWO_OR_MORE_DAYS_FLOAT("074", TransactionType.NA, TypeCodeUsage.STATUS),
    THREE_OR_MORE_DAYS_FLOAT("075", TransactionType.NA, TypeCodeUsage.STATUS),
    ADJUSTMENT_TO_BALANCES("076", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_ADJUSTMENT_TO_BALANCES_MTD("077", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_ADJUSTMENT_TO_BALANCES_YTD("078", TransactionType.NA, TypeCodeUsage.STATUS),
    FOUR_DAY_FLOAT("079", TransactionType.NA, TypeCodeUsage.STATUS),
    FIVE_DAY_FLOAT("080", TransactionType.NA, TypeCodeUsage.STATUS),
    SIZ_DAY_FLOAT("081", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_ONE_DAY_FLOAT_MTD("082", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_ONE_DAY_FLOAT_YTD("083", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_TWO_DAY_FLOAT_MTD("084", TransactionType.NA, TypeCodeUsage.STATUS),
    AVERAGE_TWO_DAY_FLOAT_YTD("085", TransactionType.NA, TypeCodeUsage.STATUS),
    TRANSFER_CALCULATION("086", TransactionType.NA, TypeCodeUsage.STATUS),
    TOTAL_CREDITS("100", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_CREDIT_AMOUNT_MTD("101", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CREDITS_NOT_DETAILED("105", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DEPOSITS_SUBJECT_TO_FLOAT("106", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    SUMMARY_TOTAL_ADJUSTMENT_CREDITS_YTD("107", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DETAIL_CREDIT("108", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SUMMARY_CURRENT_DAY_TOTAL_LOCKBOX_DEPOSITS("109", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    SUMMARY_TOTAL_LOCKBOX_DEPOSITS("110", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DETAIL_LOCKBOX_DEPOSIT("115", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    DETAIL_ITEM_IN_LOCKBOX_DEPOSIT("116", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    DETAIL_LOCKBOX_ADJUSTMENT_CREDIT("118", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    EDI_TRANSACTION_CREDIT_SUMMARY("120", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    EDI_TRANSACTION_CREDIT_DETAIL("121", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    EDIBANX_CREDIT_RECEIVED("122", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    EDIBANX_CREDIT_RETURN("123", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_CONCENTRATION_CREDITS("130", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_DTC_CREDITS("131", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DTC_CONCENTRATION_CREDIT("135", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ITEM_IN_DTC_DEPOSIT("136", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_CREDITS("140", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    ACH_CREDIT_RECEIVED("142", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ITEM_IN_ACH_DEPOSIT("143", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ACH_CONCENTRATION_CREDIT("145", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_BANK_CARD_DEPOSITS("146", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_BANK_CARD_DEPOSIT("147", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_PREAUTHORIZED_PAYMENT_CREDITS("150", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    PREAUTHORIZED_DREFT_CREDIT("155", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ITEM_IN_PAC_DEPOSIT("156", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_DISBURSING_FUNDING_CREDITS("160", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CORPORATE_TRADE_PAYMENT_SETTLEMENT_CREDIT("162", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CORPORATE_TRADE_PAYMENT_CREDITS("163", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CORPORATE_TRADE_PAYMENT_CREDIT("164", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    PREAUTHORIZED_ACH_CREDIT("165", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ACH_SETTLEMENT_CREDIT("166", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ACH_SETTLEMENT_CREDITS("167", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    ACH_RETURN_ITEM_OR_ADJUSTMENT_SETTLEMENT_CREDIT("168", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MISC_ACH_CREDIT("169", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_OTHER_CHECK_DEPOSITS("170", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_LOAN_DEPOSIT("171", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    DEPOSIT_CORRECTION("172", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    BANK_PREPARED_DEPOSIT("173", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    OTHER_DEPOSIT("174", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CHECK_DEPOSIT_PACKAGE("175", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    RE_PRESENTED_CHECK_DEPOSIT("176", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    LIST_POST_CREDITS("178", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_LOAN_PROCEEDS("180", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_BANK_PREPARED_DEPOSITS("182", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DRAFT_DEPOSIT("184", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_MISC_DEPOSITS("185", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_CACHE_LETTER_CREDITS("186", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CASH_LETTER_CREDIT("187", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_CASH_LETTER_ADJUSTMENTS("188", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CASH_LETTER_ADJUSTMENT_CREDIT("189", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_INCOMING_MONEY_TRANSFERS("190", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_INCOMING_INTERNAL_MONEY_TRANSFER("191", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INCOMING_MONEY_TRANSFER("195", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MONEY_TRANSFER_ADJUSTMENT_CREDIT("196", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    COMPENSATION("198", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_AUTOMATIC_TRANSFER_CREDITS("200", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_AUTOMATIC_TRANSFER_CREDIT("201", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    BOND_OPERATIONS_CREDIT("202", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_BOOK_TRANSFER_CREDITS("205", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    BOOK_TRANSFER_CREDIT("206", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_INTERNATIONAL_MONEY_TRANSFER_CREDITS("207", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_INTERNATIONAL_MONEY_TRANSFER_CREDIT("208", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_INTERNATIONAL_CREDITS("210", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    FOREIGN_LETTER_OF_CREDIT("212", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    LETTER_OF_CREDIT("213", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOREIGN_EXCHANGE_OF_CREDIT("214", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_LETTERS_OF_CREDIT("215", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    FOREIGN_REMITTANCE_CREDIT("216", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOREIGN_COLLECTION_CREDIT("218", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOREIGN_CHECK_PURCHASE("221", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOREIGN_CHECK_DEPOSIT("222", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    COMMISSION("224", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INTERNATIONAL_MONEY_MARKET_TRADING_CREDIT("226", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    STANDING_ORDER("227", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_INTERNATIONAL_CREDIT("229", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_SECURITY_CREDITS("230", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_COLLECTION_CREDITS("231", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    SALE_OF_DEBT_SECURITY("232", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SECURITIES_SOLD("233", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SALE_OF_EQUITY_SECURITY("234", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MATURED_REVERSE_REPURCHASE_ORDER("235", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MATURITY_OF_DEBT_SECURITY("236", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INDIVIDUAL_COLLECTION_CREDIT("237", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    COLLECTION_OF_DIVIDENDS("238", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_BANKERS_ACCEPTANCE_CREDITS("239", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    COUPON_COLLECTIONS_BANKS("240", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    BANKERS_ACCEPTANCE("241", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    COLLECTION_OF_INTEREST_INCOME("242", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MATURED_FED_FUNDS_PURCHASED("243", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INTEREST_MATURED_PRINCIPAL_PAYMENT_CREDIT("244", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MONTHLY_DIVIDENDS("245", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    COMMERCIAL_PAPER_CREDIT("246", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CAPITAL_CHANGE_CREDIT("247", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SAVINGS_BONDS_SALES_ADJUSTMENT_CREDIT("248", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_SECURITY_CREDIT("249", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_CHECKS_POSTED_AND_RETURNED("250", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_DEBIT_REVERSALS("251", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    DEBIT_REVERSAL("252", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    POSTING_ERROR_CORRECTION_CREDIT("254", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CHECK_POSTED_AND_RETURNED("255", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_RETURN_ITEMS_CREDIT("256", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_ACH_RETURN_ITEM_CREDIT("257", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ACH_REVERSAL_CREDIT("258", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_REJECTED_CREDITS("260", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_REJECTED_CREDIT("261", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    OVERDRAFT_CREDIT("263", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    RETURN_ITEM_CREDIT("266", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    RETURN_ITEM_ADJUSTMENT_CREDIT("268", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_ZBA_CREDITS("270", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    NET_ZERO_BALANCE_AMOUNT("271", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CUMULATIVE_ZBA_OR_DISBURSEMENT_CREDITS("274", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ZBA_CREDIT("275", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ZBA_FLOAT_ADJUSTMENT("276", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ZBA_CREDIT_TRANSFER("277", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ZBA_CREDIT_ADJUSTMENT("278", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_CONTROLLED_DISBURSING_CREDITS("280", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_CONTROLLED_DISBURSING_CREDIT("281", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_DTC_DISBURSING_CREDITS("285", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_DTC_DISBURSING_CREDIT("286", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_ATM_CREDITS("294", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    ATM_CREDIT("295", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    COMMERCIAL_DEPOSIT("301", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CORRESPONDENT_BANK_DEPOSIT("302", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_WIRE_TRANSFER_IN_FF("303", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_WIRE_TRANSFER_IN_CHF("304", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_FED_FUNDS_SOLD("305", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    FED_FUNDS_SOLD("306", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_TRUST_CREDITS("307", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TRUST_CREDIT("308", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_VALUE_DATED_FUNDS("309", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_COMMERCIAL_DEPOSITS("310", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_INTERNATIONAL_CREDITS_FF("315", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_INTERNATIONAL_CREDITS_CHF("316", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_FOREIGN_CHECK_PURCHASED("318", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    LATE_DEPOSIT("319", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_SOLD_FF("320", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_SOLD_CHF("321", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_MATURED_FF("324", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_MATURITY_CHF("325", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_INTEREST("326", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_MATURITY("327", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_INTEREST_FF("328", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_INTEREST_CHF("329", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_ESCROW_CREDITS("330", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_ESCROW_CREDIT("331", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_MISCELLANEOUS_SECURITIES_CREDITS_FF("332", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_MISCELLANEOUS_SECURITIES_CREDITS_CHF("336", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_SOLD("338", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_BROKER_DEPOSITS("340", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_BROKER_DEPOSITS_FF("341", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    BROKER_DEPOSIT("342", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_BROKER_DEPOSITS_CHF("343", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_BACK_VALUE_CREDIT("344", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ITEM_IN_BROKERS_DEPOSIT("345", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SWEEP_INTEREST_INCOME("346", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SWEEP_PRINCIPAL_SELL("347", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FUTURES_CREDIT("348", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    PRINCIPAL_PAYMENTS_CREDIT("349", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INVESTMENT_SOLD("350", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_INVESTMENT_SOLD("351", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_CASH_CENTER_CREDITS("352", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CASH_CENTER_CREDIT("353", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INTEREST_CREDIT("354", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INVESTMENT_INTEREST("355", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_CREDIT_ADJUSTMENT("356", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CREDIT_ADJUSTMENT("357", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    YTD_ADJUSTMENT_CREDIT("358", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    INTEREST_ADJUSTMENT_CREDIT("359", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CREDIS_LESS_WIRE_TRANSFER_AND_RETURNED_CHECKS("360", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    GRAND_TOTAL_CREDITS_LESS_GRAND_TOTAL_DEBITS("361", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    CORRESPONDENT_COLLECTION("362", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CORRESPONDENT_COLLECTION_ADJUSTMENT_CREDIT("363", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    LOAN_PARTICIPATION_CREDIT("364", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CURRENCY_AND_COIN_DEPOSITED("366", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOOD_STAMP_LETTER_CREDIT("367", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FOOD_STAMP_ADJUSTMENT_CREDIT("368", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CLEARING_SETTLEMENT_CREDIT("369", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_BACK_VALUE_CREDITS("370", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    BACK_VALUE_ADJUSTMENT_CREDIT("372", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CUSTOMER_PAYROLL_CREDIT("373", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_STATEMENT_RECAP_CREDIT("374", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    SAVINGS_BOND_LETTER_OR_ADJUSTMENT_CREDIT("376", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TREASURY_TAX_AND_LOAN_CREDIT("377", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TRANSFER_OF_TREASURY_CREDIT("378", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_GOVERNMENT_CHECKS_CASH_LETTER_CREDIT("379", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_GOVERNMENT_CHECK_ADJUSTMENT_CREDIT("381", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_POSTAL_MONEY_ORDER_CREDIT("382", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_POSTAL_MONEY_ORDER_ADJUSTMENT_CREDIT("383", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_CASH_LETTER_AUTO_CHARGE_CREDIT("384", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_UNIVERSAL_CREDITS("385", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    FRB_CASH_LETTER_AUTO_CHARGE_ADJUSTMENT_CREDIT("386", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_FINE_SORT_CASH_LETTER_CREDIT("387", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FRB_FINE_SORT_ADJUSTMENT_CREDIT("388", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_FREIGHT_PAYMENT_CREDITS("389", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    TOTAL_MISCELLANEOUS_CREDITS("390", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    UNIVERSAL_CREDIT("391", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FREIGHT_PAYMENT_CREDIT("392", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    ITEMIZED_CREDIT_OVER_10000("393", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CUMULATIVE_CREDITS("394", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    CHECK_REVERSAL("395", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    FLOAT_ADJUSTMENT_CREDIT("397", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_FEE_REFUND("398", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_CREDIT("399", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    TOTAL_DEBITS("400", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DEBIT_AMOUNT_MTD("401", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TODAYS_TOTAL_DEBITS("403", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DEBIT_LESS_WIRE_TRANSFERS_AND_CHARGE_BACKS("405", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    DEBITS_NOT_DETAILED("406", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FLOAT_ADJUSTMENT_DEBIT("408", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DEBIT_ANY_TYPE("409", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_YTD_ADJUSTMENT("410", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DEBITS_EXCLUDING_RETURNED_ITEMS("412", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    LOCKBOX_DEBIT("415", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_LOCKBOX_DEBITS("416", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    EDI_TRANSACTION_DEBITS("420", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    EDI_TRANSACTION_DEBIT("421", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    EDIBANX_SETTLEMENT_DEBIT("422", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    EDIBANX_RETURN_ITEM_DEBIT("423", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_PAYABLE_THROUGH_DRAFTS("430", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    PAYABLE_THROUGH_DRAFT("435", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ACH_CONCENTRATION_DEBIT("445", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_DISBURSEMENT_FUNDING_DEBITS("446", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ACH_DISBURSEMENT_FUNDING_DEBIT("447", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_DEBITS("450", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ACH_DEBIT_RECEIVED("451", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ITEM_IN_ACH_DISBURSEMENT_OR_DEBIT("452", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    PREAUTHORIZED_ACH_DEBIT("455", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ACCOUNT_ENVELOPE_HOLDER_INITIATED_ACH_DEBIT("462", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CORPORATE_TRADE_PAYMENT_DEBITS("463", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CORPORATE_TRADE_PAYMENT_DEBIT("464", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CORPORATE_TRADE_PAYMENT_SETTLEMENT_DEBIT("465", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ACH_SETTLEMENT_DEBIT("466", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ACH_SETTLEMENT_DEBITS("467", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ACH_RETURN_ITEM_OR_ADJUSTMENT_SETTLEMENT_DEBIT("468", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_ACH_DEBIT("469", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_CHECK_PAID("470", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_CHECK_PAID_CUMULATIVE_MTD("471", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CUMULATIVE_CHECKS_PAID("472", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CERTIFIED_CHECK_DEBIT("474", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CHECK_PAID("475", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FEDERAL_RESERVE_BANK_LETTER_DEBIT("476", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    BANK_ORIGINATED_DEBIT("477", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    LIST_POST_DEBITS("478", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    LIST_POST_DEBIT("479", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_LOAN_PAYMENTS("480", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_LOAN_PAYMENT("481", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_BANK_ORIGINATED_DEBITS("482", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    DRAFT("484", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DTC_DEBIT("485", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_CASH_LETTER_DEBITS("486", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CASH_LETTER_DEBIT("487", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CASH_LETTER_ADJUSTMENT_DEBIT("489", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_OUTGOING_MONEY_TRANSFERS("490", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_OUTGOING_INTERNAL_MONEY_TRANSFER("491", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CUSTOMER_TERMINAL_INITIATED_MONEY_TRANSFER("493", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    OUTGOING_MONEY_TRANSFER("495", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MONEY_TRANSFER_ADJUSTMENT_DEBIT("496", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    COMPENSATION_DEBIT("498", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_AUTOMATIC_TRANSFER_DEBITS("500", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_AUTOMATIC_TRANSFER_DEBIT("501", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    BOND_OPERATIONS_DEBIT("502", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_BOOK_TRANSFER_DEBITS("505", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    BOOK_TRANSFER_DEBIT("506", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_INTERNATIONAL_MONEY_TRANSFER_DEBITS("507", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_INTERNATIONAL_MONEY_TRANSFER_DEBITS("508", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_INTERNATIONAL_DEBITS("510", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    LETTER_OF_CREDIT_DEBIT("512", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    LETTER_OF_CREDIT_DEB("513", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FOREIGN_EXCHANGE_DEBIT("514", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_LETTERS_OF_CREDIT_DEBIT("515", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FOREIGN_REMITTANCE_DEBIT("516", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FOREIGN_COLLECTION_DEBIT("518", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FOREIGN_CHECKS_PAID("522", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    COMMISSION_DEBIT("524", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INTERNATIONAL_MONEY_MARKET_TRADING_DEBIT("526", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    STANDING_ORDER_DEBIT("527", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_INTERNATIONAL_DEBIT("529", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_SECURITY_DEBITS("530", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    SECURITIES_PURCHASED("531", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_AMOUNT_OF_SECURITIES_PURCHASED("532", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    SECURITY_COLLECTION_DEBIT("533", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_MISCELLANEOUS_SECURITIES_DB_FF("534", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    PURCHASE_OF_EQUITY_SECURITIES("535", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_MISCELLANEOUS_SECURITIES_DEBIT_CHF("536", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_COLLECTION_DEBIT("537", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    MATURED_REPURCHASE_ORDER("538", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_BANKERS_ACCEPTANCES_DEBIT("539", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    COUPON_COLLECTION_DEBIT("540", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    BANKERS_ACCEPTANCES("541", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    PURCHASE_OF_DEBT_SECURITIES("542", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DOMESTIC_COLLECTION("543", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INTEREST_MATURED_PRINCIPAL_PAYMENT_DEBIT("544", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    COMMERCIAL_PAPER_DEBIT("546", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CAPITAL_CHANGE_DEBIT("547", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    SAVINGS_BONDS_SALES_ADJUSTMENT_DEBIT("548", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_SECURITY_DEBIT("549", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_DEPOSITED_ITEMS_RETURNED("550", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_CREDIT_REVERSALS("551", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CREDIT_REVERSAL("552", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    POSTING_ERROR_CORRECTION_DEBIT("554", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DEPOSITED_ITEM_RETURNED("555", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ACH_RETURN_ITEMS_DEBIT("556", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_ACH_RETURN_ITEM_DEBIT("557", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ACH_REVERSAL_DEBIT("558", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_REJECTED_DEBITS("560", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_REJECTED_DEBIT("561", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    OVERDRAFT_DEBIT("563", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    OVERDRAFT_FEE("564", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    RETURN_ITEM_DEBIT("566", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    RETURN_ITEM_FEE("567", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    RETURN_ITEM_ADJUSTMENT_DEBIT("568", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ZBA_DEBITS("570", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CUMULATIVE_ZBA_DEBITS("574", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ZBA_DEBIT("575", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ZBA_DEBIT_TRANSFER("577", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ZBA_DEBIT_ADJUSTMENT("578", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_CONTROLLED_DISBURSING_DEBITS("580", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_CONTROLLED_DISBURSING_DEBIT("581", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_DISBURSING_CHECKS_PAID_EARLY_AMOUNT("583", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DISBURSING_CHECKS_PAID_LATER_AMOUNT("584", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    DISBURSING_FUNDING_REQUIREMENT("585", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FRB_PRESENTMENT_ESTIMATE("586", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    LATE_DEBITS_AFTER_NOTIFICATION("587", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DISBURSING_CHECKS_PAID_LAST_AMOUNT("588", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_DTC_DEBITS("590", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_ATM_DEBITS("594", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ATM_DEBIT("595", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ARP_DEBITS("596", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ARP_DEBIT("597", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ESTIMATED_TOTAL_DISBURSEMENT("601", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    ADJUSTED_TOTAL_DISBURSEMENT("602", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_FUNDS_REQUIRED("610", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_WIRE_TRANSFERS_OUT_CHF("611", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_WIRE_TRANSFERS_OUT_FF("612", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_INTERNATIONAL_DEBIT_CHF("613", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_INTERNATIONAL_DEBIT_FF("614", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_FEDERAL_RESERVE_BANK_COMMERCIAL_BANK_DEBIT("615", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FEDERAL_RESERVE_BANK_COMMERCIAL_BANK_DEBIT("616", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_SECURITIES_PURCHASED_CHF("617", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_SECURITIES_PURCHASED_FF("618", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_BROKER_DEBITS_CHF("621", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    BROKER_DEBIT("622", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_BROKER_DEBITS_FF("623", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_BROKER_DEBITS("625", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_FED_FUNDS_PURCHASED("626", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FED_FUNDS_PURCHASED("627", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_CASH_CENTER_DEBITS("628", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CASH_CENTER_DEBIT("629", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_DEBIT_ADJUSTMENTS("630", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    DEBIT_ADJUSTMENT("631", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_TRUST_DEBITS("632", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TRUST_DEBIT("633", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    YTD_ADJUSTMENT_DEBIT("634", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_ESCROW_DEBITS("640", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_ESCROW_DEBIT("641", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INDIVIDUAL_BACK_VALUE_DEBIT("644", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TRANSFER_CALCULATION_DEBIT("646", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INVESTMENTS_PURCHASED("650", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    INDIVIDUAL_INVESTMENT_PURCHASED("651", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INTEREST_DEBIT("654", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_INVESTMENT_INTEREST_DEBITS("655", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    SWEEP_PRINCIPAL_BUY("656", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FUTURES_DEBIT("657", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    PRINCIPAL_PAYMENTS_DEBIT("658", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INTEREST_ADJUSTMENT_DEBIT("659", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ACCOUNT_ANALYSIS_FEE("661", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CORRESPONDENT_COLLECTION_DEBIT("662", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CORRESPONDENT_COLLECTION_ADJUSTMENT_DEBIT("663", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    LOAN_PARTICIPATION_DEBIT("664", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    INTERCEPT_DEBITS("665", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    CURRENCY_AND_COIN_SHIPPED("666", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FOOD_STAMP_LETTER_DEBIT("667", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FOOD_STAMP_ADJUSTMENT_DEBIT("668", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CLEARING_SETTLEMENT_DEBIT("669", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_BACK_VALUE_DEBITS("670", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    BACK_VALUE_ADJUSTMENT_DEBIT("672", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CUSTOMER_PAYROLL_DEBIT("673", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_STATEMENT_RECAP_DEBIT("674", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    SAVINGS_BOND_LETTER_OR_ADJUSTMENT_DEBIT("676", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TREASURY_TAX_AND_LOAN_DEBIT("677", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TRANSFER_OF_TREASURY_DEBIT("678", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_GOVERNMENT_CHECKS_CASH_LETTER_DEBIT("679", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_GOVERNMENT_CHECK_ADJUSTMENT_DEBIT("681", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_POSTAL_MONEY_ORDER_DEBIT("682", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_POSTAL_MONEY_ORDER_ADJUSTMENT_DEBIT("683", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_CASH_LETTER_AUTO_CHARGE_DEBIT("684", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    TOTAL_UNIVERSAL_DEBITS("685", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    FRB_CASH_LETTER_AUTO_CHARGE_ADJUSTMENT_DEBIT("686", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_FINE_SORT_CASH_LETTER_DEBIT("687", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_FINE_SORT_ADJUSTMENT_DEBIT("688", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FRB_FREIGHT_PAYMENT_DEBITS("689", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    TOTAL_MISCELLANEOUS_DEBITS("690", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    UNIVERSAL_DEBIT("691", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    FREIGHT_PAYMENT_DEBIT("692", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    ITEMIZED_DEBIT_OVER_10000("693", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DEPOSIT_REVERSAL("694", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    DEPOSIT_CORRECTION_DEBIT("695", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    REGULAR_COLLECTION_DEBIT("696", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    CUMULATIVE_DEBITS("697", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_FEES("698", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    MISCELLANEOUS_DEBIT("699", TransactionType.DEBIT, TypeCodeUsage.DETAIL),
    PRINCIPAL_LOAN_BALANCE("701", TransactionType.NA, TypeCodeUsage.STATUS),
    AVAILABLE_COMMITMENT_AMOUNT("703", TransactionType.NA, TypeCodeUsage.STATUS),
    PAYMENT_AMOUNT_DUE("705", TransactionType.NA, TypeCodeUsage.STATUS),
    PRINCIPAL_AMOUNT_PAST_DUE("707", TransactionType.NA, TypeCodeUsage.STATUS),
    INTEREST_AMOUNT_PAST_DUE("709", TransactionType.NA, TypeCodeUsage.STATUS),
    TOTAL_LOAN_PAYMENT("720", TransactionType.CREDIT, TypeCodeUsage.SUMMARY),
    AMOUNT_APPLIED_TO_INTEREST("721", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_PRINCIPAL("722", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_ESCROW("723", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_LATE_CHARGES("724", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_BUYDOWN("725", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_MISC_FEES("726", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_DEFERRED_INTEREST_DETAIL("727", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    AMOUNT_APPLIED_TO_SERVICE_CHARGE("728", TransactionType.CREDIT, TypeCodeUsage.DETAIL),
    LOAN_DISBURSEMENT("760", TransactionType.DEBIT, TypeCodeUsage.SUMMARY),
    NON_MONETARY_DETAIL_INFO("890", TransactionType.NA, TypeCodeUsage.DETAIL);

    private final String code;
    private final TransactionType transactionType;
    private final TypeCodeUsage usage;

    private TypeCode(String code, TransactionType transactionType, TypeCodeUsage usage) {
        this.code = code;
        this.transactionType = transactionType;
        this.usage = usage;
    }

    public String getCode() {
        return this.code;
    }

    public boolean isDetail() {
        return this.usage == TypeCodeUsage.DETAIL;
    }

    public boolean isStatus() {
        return this.usage == TypeCodeUsage.STATUS;
    }

    public boolean isSummary() {
        return this.usage == TypeCodeUsage.SUMMARY;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public static TypeCode get(String code) {
        for (TypeCode recordCode : TypeCode.values()) {
            if (!recordCode.code.equals(code)) continue;
            return recordCode;
        }
        throw new InvalidFieldValueException("%s must be a valid TypeCode: %s", "typeCode", code);
    }
}

