/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain.fundsavailability;

import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailability;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.fundsavailability.DistributedSimpleSubRecord;
import java.util.Currency;
import java.util.Objects;

public final class DistributedSimpleFundsAvailability
implements FundsAvailability {
    private final DistributedSimpleSubRecord distributedSimpleSubRecord;
    private final Currency currency;

    DistributedSimpleFundsAvailability(DistributedSimpleSubRecord distributedSimpleSubRecord, Currency currency) {
        this.distributedSimpleSubRecord = distributedSimpleSubRecord;
        this.currency = currency;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DistributedSimpleFundsAvailability)) {
            return false;
        }
        DistributedSimpleFundsAvailability that = (DistributedSimpleFundsAvailability)obj;
        return Objects.equals(this.distributedSimpleSubRecord, that.distributedSimpleSubRecord);
    }

    public String toString() {
        return "DistributedSimpleFundsAvailability{distributedSimpleSubRecord=" + String.valueOf(this.distributedSimpleSubRecord) + "}";
    }

    public int hashCode() {
        return Objects.hashCode(this.distributedSimpleSubRecord);
    }

    @Override
    public FundsType getFundsType() {
        return this.distributedSimpleSubRecord.getFundsType();
    }

    public double getImmediateAvailabilityAmount() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.distributedSimpleSubRecord.getImmediateAvailabilityAmount(), this.currency);
    }

    public double getOneDayAvailabilityAmount() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.distributedSimpleSubRecord.getOneDayAvailabilityAmount(), this.currency);
    }

    public double getMoreThanOneDayAvailabilityAmount() {
        return ValueUtils.convertLongToDoubleWithCurrency(this.distributedSimpleSubRecord.getMoreThanOneDayAvailabilityAmount(), this.currency);
    }
}

