/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.domain.fundsavailability;

import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.domain.fundsavailability.DistributedDetailedFundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.DistributedSimpleFundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.FundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.SimpleFundsAvailability;
import co.kuali.bai.v2.domain.fundsavailability.ValueDatedFundsAvailability;
import co.kuali.bai.v2.record.fundsavailability.DistributedDetailedSubRecord;
import co.kuali.bai.v2.record.fundsavailability.DistributedSimpleSubRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import co.kuali.bai.v2.record.fundsavailability.SimpleSubRecord;
import co.kuali.bai.v2.record.fundsavailability.ValueDatedSubRecord;
import java.util.Currency;

public final class FundsAvailabilityFactory {
    private FundsAvailabilityFactory() {
    }

    public static FundsAvailability create(FundsAvailabilitySubRecord subRecord, Currency currency) {
        FundsType fundsType = subRecord.getFundsType();
        return switch (fundsType) {
            case FundsType.IMMEDIATE_AVAILABILITY, FundsType.ONE_DAY_AVAILABILITY, FundsType.TWO_OR_MORE_DAYS_AVAILABILITY, FundsType.UNKNOWN -> new SimpleFundsAvailability((SimpleSubRecord)subRecord);
            case FundsType.SIMPLE_DISTRIBUTED_AVAILABILITY -> new DistributedSimpleFundsAvailability((DistributedSimpleSubRecord)subRecord, currency);
            case FundsType.VALUE_DATED -> new ValueDatedFundsAvailability((ValueDatedSubRecord)subRecord);
            case FundsType.DETAILED_DISTRIBUTED_AVAILABILITY -> new DistributedDetailedFundsAvailability((DistributedDetailedSubRecord)subRecord, currency);
            default -> throw new IllegalArgumentException("Unknown funds type: " + String.valueOf((Object)fundsType));
        };
    }
}

