/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.RequiredFieldMissingException;
import co.kuali.bai.v2.record.Record;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRecord
implements Record {
    protected final String recordString;
    protected final String[] fields;
    private final int recordCount;

    protected AbstractRecord(String recordString, ContinuationRecord ... continuationRecords) {
        this.recordString = this.unify(recordString, continuationRecords);
        this.recordCount = 1 + continuationRecords.length;
        this.fields = this.processRecordString();
        this.validate(this.fields);
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    protected String unify(String primaryRecordString, ContinuationRecord ... continuationRecords) {
        if (ArrayUtils.isEmpty((Object[])continuationRecords)) {
            return primaryRecordString;
        }
        AbstractRecord.validateLineTermination(primaryRecordString);
        String primaryRecordStringWithoutTerminatingSlash = StringUtils.removeEnd((String)primaryRecordString, (String)"/");
        StringBuilder unifiedRecordString = new StringBuilder(primaryRecordStringWithoutTerminatingSlash);
        for (ContinuationRecord continuationRecord : continuationRecords) {
            String additionalFields = continuationRecord.getAdditionalFields();
            AbstractRecord.validateLineTermination(additionalFields);
            String additionalFieldStringWithoutTerminatingSlash = StringUtils.removeEnd((String)additionalFields, (String)"/");
            unifiedRecordString.append(",").append(additionalFieldStringWithoutTerminatingSlash);
        }
        unifiedRecordString.append("/");
        return unifiedRecordString.toString();
    }

    protected static void validateLineTermination(String recordComponentString) {
        if (!recordComponentString.endsWith("/")) {
            throw new Bai2ParseException("recordComponentString must end with a '/' -- " + recordComponentString);
        }
    }

    protected String[] processRecordString() {
        String[] localFields = this.recordString.split(",", -1);
        this.validateSlashTerminatesTheRecord(localFields);
        AbstractRecord.stripTerminatingSlash(localFields);
        return localFields;
    }

    protected void validateSlashTerminatesTheRecord(String[] localFields) {
        int lastFieldIndex = localFields.length - 1;
        String lastField = localFields[lastFieldIndex];
        if (!lastField.endsWith("/")) {
            throw new Bai2ParseException("The last field must end with a slash ('/'): " + this.recordString);
        }
    }

    protected static void stripTerminatingSlash(String[] localFields) {
        int lastFieldIndex = localFields.length - 1;
        String lastField = localFields[lastFieldIndex];
        localFields[lastFieldIndex] = StringUtils.removeEnd((String)lastField, (String)"/");
    }

    private void validate(String[] localFields) {
        this.validateRecordCode();
        this.validateNumberOfFields(localFields);
        this.validateRequiredFieldsArePresent();
        this.recordSpecificValidation();
    }

    protected void recordSpecificValidation() {
    }

    private void validateRecordCode() {
        String recordCode = this.fields[0];
        if (!this.getRecordCode().getCode().equals(recordCode)) {
            throw new InvalidFieldValueException("%s must be " + this.getRecordCode().getCode() + ": %s", "recordCode", recordCode);
        }
    }

    protected abstract int expectedNumberOfFields(String[] var1);

    protected void validateNumberOfFields(String[] localFields) {
        int expectedNumberOfFields = this.expectedNumberOfFields(localFields);
        if (localFields.length != expectedNumberOfFields) {
            throw new Bai2ParseException("Incorrect number of fields (" + localFields.length + ") for record; expected " + expectedNumberOfFields + " -- " + this.recordString);
        }
    }

    protected abstract Map<String, Integer> getRequiredFieldsNameToIndexMapping();

    private void validateRequiredFieldsArePresent() {
        this.getRequiredFieldsNameToIndexMapping().entrySet().stream().filter(entry -> StringUtils.isBlank((CharSequence)this.fields[(Integer)entry.getValue()])).findAny().ifPresent(entry -> {
            throw new RequiredFieldMissingException((String)entry.getKey());
        });
    }
}

