/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record;

import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.FundsType;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Currency;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class ValueUtils {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyMMdd", Locale.US);
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("HHmm", Locale.US);
    private static final Pattern ALPHANUMERIC_IDENTIFIER_PATTERN = Pattern.compile("[A-Za-z0-9\\-_]+");
    private static final Pattern CUSTOMER_REFERENCE_PATTERN = Pattern.compile("[A-Za-z0-9\\-_.:() ]+");
    private static final Pattern TEXT_PATTERN = Pattern.compile("^[^\\/,].*$");

    private ValueUtils() {
    }

    public static @Nullable FundsType optionalValueIsFundsType(String fieldValue) {
        if (fieldValue.isBlank()) {
            return FundsType.UNKNOWN;
        }
        String trimmedFieldValue = fieldValue.trim();
        return FundsType.get(trimmedFieldValue);
    }

    public static @Nullable Currency optionalValueIsCurrency(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        try {
            String trimmedFieldValue = fieldValue.trim();
            return Currency.getInstance(trimmedFieldValue);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFieldValueException("%s must be a valid currency code: %s", fieldName, fieldValue, e);
        }
    }

    private static Integer requiredValueIsInteger(String fieldName, String fieldValue) {
        try {
            String trimmedFieldValue = fieldValue.trim();
            return Integer.valueOf(trimmedFieldValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidFieldValueException("%s must be a valid integer: %s", fieldName, fieldValue, e);
        }
    }

    public static Integer requiredValueIsNonNegativeInteger(String fieldName, String fieldValue) {
        Integer value = ValueUtils.requiredValueIsInteger(fieldName, fieldValue);
        if (value < 0) {
            throw new InvalidFieldValueException("%s must be a non-negative integer: %s", fieldName, fieldValue);
        }
        return value;
    }

    public static @Nullable Integer optionalValueIsNonNegativeInteger(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsNonNegativeInteger(fieldName, fieldValue);
    }

    public static Integer requiredValueIsPositiveInteger(String fieldName, String fieldValue) {
        Integer value = ValueUtils.requiredValueIsInteger(fieldName, fieldValue);
        if (value <= 0) {
            throw new InvalidFieldValueException("%s must be a positive integer: %s", fieldName, fieldValue);
        }
        return value;
    }

    public static String requiredValueIsAlphanumeric(String fieldName, String fieldValue) {
        String trimmedFieldValue = fieldValue.trim();
        if (StringUtils.isAlphanumeric((CharSequence)trimmedFieldValue)) {
            return trimmedFieldValue;
        }
        throw new InvalidFieldValueException("%s must be alphanumeric: %s", fieldName, fieldValue);
    }

    public static String requiredValueIsAlphanumericHyphenUnderscore(String fieldName, String fieldValue) {
        String trimmedFieldValue = fieldValue.trim();
        if (ALPHANUMERIC_IDENTIFIER_PATTERN.matcher(trimmedFieldValue).matches()) {
            return trimmedFieldValue;
        }
        throw new InvalidFieldValueException("%s must be alphanumeric, '-', or '_': %s", fieldName, fieldValue);
    }

    public static @Nullable String optionalValueIsAlphanumericHyphenUnderscore(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsAlphanumericHyphenUnderscore(fieldName, fieldValue);
    }

    public static @Nullable String optionalValueIsCustomerReference(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        String trimmedFieldValue = fieldValue.trim();
        if (CUSTOMER_REFERENCE_PATTERN.matcher(trimmedFieldValue).matches()) {
            return trimmedFieldValue;
        }
        throw new InvalidFieldValueException("%s must be alphanumeric, ' ', '-', '_', '.', ':', '(', or ')': %s", fieldName, fieldValue);
    }

    public static @Nullable String optionalValueIsAlphanumeric(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsAlphanumeric(fieldName, fieldValue);
    }

    public static @Nullable String optionalValueIsAlphanumericSpace(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        String trimmedFieldValue = fieldValue.trim();
        if (StringUtils.isAlphanumericSpace((CharSequence)trimmedFieldValue)) {
            return trimmedFieldValue;
        }
        throw new InvalidFieldValueException("%s must be alphanumeric/space: %s", fieldName, fieldValue);
    }

    public static LocalDate requiredValueIsLocalDate(String fieldName, String fieldValue) {
        try {
            String trimmedFieldValue = fieldValue.trim();
            return LocalDate.parse(trimmedFieldValue, DATE_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new InvalidFieldValueException("%s must be a valid date in YYMMDD format: %s", fieldName, fieldValue, e);
        }
    }

    public static LocalTime requiredValueIsLocalTime(String fieldName, String fieldValue) {
        try {
            String trimmedFieldValue = fieldValue.trim();
            String actualValue = "9999".equals(trimmedFieldValue) ? "2400" : trimmedFieldValue;
            return LocalTime.parse(actualValue, TIME_FORMAT);
        }
        catch (DateTimeParseException e) {
            throw new InvalidFieldValueException("%s must be a valid time in HHMM 24-hour/military format: %s", fieldName, fieldValue, e);
        }
    }

    public static @Nullable LocalTime optionalValueIsLocalTime(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsLocalTime(fieldName, fieldValue);
    }

    public static Long requiredValueIsLong(String fieldName, String fieldValue) {
        try {
            String trimmedFieldValue = fieldValue.trim();
            return Long.parseLong(trimmedFieldValue);
        }
        catch (NumberFormatException e) {
            throw new InvalidFieldValueException("%s must be a valid long: %s", fieldName, fieldValue, e);
        }
    }

    public static @Nullable Long optionalValueIsLong(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsLong(fieldName, fieldValue);
    }

    public static Long requiredValueIsNonNegativeLong(String fieldName, String fieldValue) {
        Long value = ValueUtils.requiredValueIsLong(fieldName, fieldValue);
        if (value < 0L) {
            throw new InvalidFieldValueException("%s must be a non-negative long: %s", fieldName, fieldValue);
        }
        return value;
    }

    public static @Nullable Long optionalValueIsNonNegativeLong(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsNonNegativeLong(fieldName, fieldValue);
    }

    public static Long requiredValueIsPositiveLong(String fieldName, String fieldValue) {
        Long value = ValueUtils.requiredValueIsLong(fieldName, fieldValue);
        if (value <= 0L) {
            throw new InvalidFieldValueException("%s must be a positive long: %s", fieldName, fieldValue);
        }
        return value;
    }

    public static @Nullable Long optionalValueIsPositiveLong(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        return ValueUtils.requiredValueIsPositiveLong(fieldName, fieldValue);
    }

    public static void valueIsNotProvided(String fieldName, String fieldValue) {
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            throw new InvalidFieldValueException("%s must not be provided in this scenario: %s", fieldName, fieldValue);
        }
    }

    public static double convertLongToDoubleWithCurrency(long value, Currency currency) {
        return (double)value / Math.pow(10.0, currency.getDefaultFractionDigits());
    }

    public static @Nullable String optionalValueIsText(String fieldName, String fieldValue) {
        if (StringUtils.isBlank((CharSequence)fieldValue)) {
            return null;
        }
        if (TEXT_PATTERN.matcher(fieldValue).matches()) {
            return fieldValue;
        }
        throw new InvalidFieldValueException("%s must not start with ',' or '/': %s", fieldName, fieldValue);
    }
}

