/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.account;

import co.kuali.bai.v2.Bai2ParseException;
import co.kuali.bai.v2.InvalidFieldValueException;
import co.kuali.bai.v2.domain.FundsType;
import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.domain.TypeCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecord;
import co.kuali.bai.v2.record.fundsavailability.FundsAvailabilitySubRecordFactory;
import java.util.ArrayList;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public final class AccountIdentifierAndSummaryStatusRecord
extends AbstractRecord {
    private static final int INDEX_CUSTOMER_ACCOUNT_NUMBER = 1;
    private static final int INDEX_CURRENCY_CODE = 2;
    private final String customerAccountNumber;
    private final @Nullable Currency currency;
    private final List<SummaryOrStatus> summaryOrStatuses = new ArrayList<SummaryOrStatus>();

    private AccountIdentifierAndSummaryStatusRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.customerAccountNumber = ValueUtils.requiredValueIsAlphanumeric("customerAccountNumber", this.fields[1]);
        this.currency = ValueUtils.optionalValueIsCurrency("currencyCode", this.fields[2]);
        this.summaryOrStatuses.addAll(AccountIdentifierAndSummaryStatusRecord.parseSummaryOrStatuses(this.fields));
    }

    public static AccountIdentifierAndSummaryStatusRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new AccountIdentifierAndSummaryStatusRecord(recordString, continuationRecords);
    }

    @Override
    protected void validateNumberOfFields(String[] localFields) {
        int minimumNumberOfFields = 7;
        if (localFields.length < 7) {
            throw new Bai2ParseException("Incorrect number of fields for record; minimally expected 7: " + this.recordString);
        }
        if (localFields.length == 7) {
            boolean optionalFieldsAreAllBlank = true;
            for (int i = 2; i < localFields.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)localFields[i])) continue;
                optionalFieldsAreAllBlank = false;
                break;
            }
            if (optionalFieldsAreAllBlank) {
                return;
            }
        }
        EnumSet<FundsType> fundsTypesRequiringNoAdditionalFields = EnumSet.of(FundsType.IMMEDIATE_AVAILABILITY, FundsType.ONE_DAY_AVAILABILITY, FundsType.TWO_OR_MORE_DAYS_AVAILABILITY, FundsType.UNKNOWN);
        int nextTypeCodeIndex = 3;
        while (nextTypeCodeIndex < localFields.length) {
            int nextFundsTypeIndex = nextTypeCodeIndex + 3;
            if (localFields.length < nextFundsTypeIndex) {
                throw new Bai2ParseException("Incorrect number of fields for record; minimally expected " + nextFundsTypeIndex + ": " + this.recordString);
            }
            String fundsTypeField = localFields[nextFundsTypeIndex];
            FundsType fundsType = ValueUtils.optionalValueIsFundsType(fundsTypeField);
            if (fundsTypesRequiringNoAdditionalFields.contains((Object)fundsType)) {
                nextTypeCodeIndex += 4;
            } else if (fundsType == FundsType.VALUE_DATED) {
                nextTypeCodeIndex += 6;
            } else if (fundsType == FundsType.SIMPLE_DISTRIBUTED_AVAILABILITY) {
                nextTypeCodeIndex += 7;
            } else if (fundsType == FundsType.DETAILED_DISTRIBUTED_AVAILABILITY) {
                int disbursementCountIndex = nextFundsTypeIndex + 1;
                String disbursementCountField = localFields[disbursementCountIndex];
                int distributionCount = ValueUtils.requiredValueIsNonNegativeLong("distributionCount", disbursementCountField).intValue();
                int distributionFieldCount = distributionCount * 2;
                nextTypeCodeIndex += 5;
                nextTypeCodeIndex += distributionFieldCount;
            }
            if (localFields.length >= nextTypeCodeIndex) continue;
            throw new Bai2ParseException("Incorrect number of fields for record; minimally expected " + (nextTypeCodeIndex + 1) + ": " + this.recordString);
        }
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return -1;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("customerAccountNumber", 1));
    }

    private static List<SummaryOrStatus> parseSummaryOrStatuses(String[] fields) {
        ArrayList<SummaryOrStatus> summaryOrStatuses = new ArrayList<SummaryOrStatus>();
        int nextSummaryOrStatusIndex = 3;
        while (nextSummaryOrStatusIndex < fields.length) {
            String typeCode = fields[nextSummaryOrStatusIndex];
            if (StringUtils.isNotBlank((CharSequence)typeCode)) {
                SummaryOrStatus summaryOrStatus = SummaryOrStatus.create(nextSummaryOrStatusIndex, fields);
                summaryOrStatuses.add(summaryOrStatus);
                nextSummaryOrStatusIndex += summaryOrStatus.getNumberOfFieldsEncompassed();
                continue;
            }
            int nextAmountIndex = nextSummaryOrStatusIndex + 1;
            ValueUtils.valueIsNotProvided("amount", fields[nextAmountIndex]);
            int nextItemCountIndex = nextSummaryOrStatusIndex + 2;
            ValueUtils.valueIsNotProvided("itemCount", fields[nextItemCountIndex]);
            int nextFundsTypeIndex = nextSummaryOrStatusIndex + 3;
            ValueUtils.valueIsNotProvided("fundsType", fields[nextFundsTypeIndex]);
            nextSummaryOrStatusIndex += 4;
        }
        return summaryOrStatuses;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccountIdentifierAndSummaryStatusRecord)) {
            return false;
        }
        AccountIdentifierAndSummaryStatusRecord that = (AccountIdentifierAndSummaryStatusRecord)obj;
        return Objects.equals(this.customerAccountNumber, that.customerAccountNumber) && Objects.equals(this.currency, that.currency) && Objects.equals(this.summaryOrStatuses, that.summaryOrStatuses);
    }

    public int hashCode() {
        return Objects.hash(this.customerAccountNumber, this.currency, this.summaryOrStatuses);
    }

    public String toString() {
        return "AccountIdentifierAndSummaryStatusRecord{customerAccountNumber='" + this.customerAccountNumber + "', currency=" + String.valueOf(this.currency) + ", summaryOrStatuses=" + String.valueOf(this.summaryOrStatuses) + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.ACCOUNT_IDENTIFIER;
    }

    public String getCustomerAccountNumber() {
        return this.customerAccountNumber;
    }

    public @Nullable Currency getCurrency() {
        return this.currency;
    }

    public List<SummaryOrStatus> getSummaryOrStatuses() {
        return List.copyOf(this.summaryOrStatuses);
    }

    public static final class SummaryOrStatus {
        private final TypeCode typeCode;
        private final @Nullable Long amount;
        private final @Nullable Integer itemCount;
        private final @Nullable FundsAvailabilitySubRecord fundsAvailabilitySubRecord;

        private SummaryOrStatus(TypeCode typeCode, @Nullable Long amount, @Nullable Integer itemCount, @Nullable FundsAvailabilitySubRecord fundsAvailabilitySubRecord) {
            this.typeCode = typeCode;
            this.amount = amount;
            this.itemCount = itemCount;
            this.fundsAvailabilitySubRecord = fundsAvailabilitySubRecord;
        }

        static SummaryOrStatus create(int index, String[] fields) {
            FundsAvailabilitySubRecord fundsAvailability;
            Integer itemCount;
            TypeCode typeCode = SummaryOrStatus.requiredValueIsSummaryOrStatusTypeCode(fields[index]);
            int amountIndex = index + 1;
            Long amount = SummaryOrStatus.optionalValueIsSignedLongForStatusOrUnsignedForSummary(typeCode, fields[amountIndex]);
            int itemCountIndex = index + 2;
            int fundsTypeIndex = index + 3;
            if (typeCode.isSummary()) {
                itemCount = ValueUtils.optionalValueIsNonNegativeInteger("itemCount", fields[itemCountIndex]);
                FundsType fundsType = ValueUtils.optionalValueIsFundsType(fields[fundsTypeIndex]);
                fundsAvailability = Optional.ofNullable(fundsType).map(ft -> FundsAvailabilitySubRecordFactory.create(ft, index + 4, fields)).orElse(null);
            } else {
                ValueUtils.valueIsNotProvided("itemCount", fields[itemCountIndex]);
                ValueUtils.valueIsNotProvided("fundsType", fields[fundsTypeIndex]);
                itemCount = null;
                fundsAvailability = null;
            }
            return new SummaryOrStatus(typeCode, amount, itemCount, fundsAvailability);
        }

        private static @Nullable Long optionalValueIsSignedLongForStatusOrUnsignedForSummary(TypeCode typeCode, String fieldValue) {
            String fieldName = "amount";
            Long value = ValueUtils.optionalValueIsLong("amount", fieldValue);
            if (value != null && typeCode.isSummary() && value <= 0L) {
                throw new InvalidFieldValueException("%s must be positive for a Summary TypeCode: %s", "amount", fieldValue);
            }
            return value;
        }

        private static TypeCode requiredValueIsSummaryOrStatusTypeCode(String fieldValue) {
            TypeCode tc = TypeCode.get(fieldValue);
            if (tc.isSummary() || tc.isStatus()) {
                return tc;
            }
            throw new InvalidFieldValueException("%s must be either a Summary or a Status TypeCode: %s", "typeCode", fieldValue);
        }

        public int getNumberOfFieldsEncompassed() {
            int minimalFieldsEncompassed = 4;
            int fieldsEncompassedByFundsAvailabilitySubRecord = Optional.ofNullable(this.fundsAvailabilitySubRecord).map(FundsAvailabilitySubRecord::numberOfFieldsEncompassed).orElse(0);
            return 4 + fieldsEncompassedByFundsAvailabilitySubRecord;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SummaryOrStatus)) {
                return false;
            }
            SummaryOrStatus that = (SummaryOrStatus)obj;
            return this.typeCode == that.typeCode && Objects.equals(this.amount, that.amount) && Objects.equals(this.itemCount, that.itemCount) && Objects.equals(this.fundsAvailabilitySubRecord, that.fundsAvailabilitySubRecord);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.typeCode, this.amount, this.itemCount, this.fundsAvailabilitySubRecord});
        }

        public String toString() {
            return "SummaryOrStatus{typeCode=" + String.valueOf((Object)this.typeCode) + ", amount=" + this.amount + ", itemCount=" + this.itemCount + ", fundsAvailabilitySubRecord=" + String.valueOf(this.fundsAvailabilitySubRecord) + "}";
        }

        public TypeCode getTypeCode() {
            return this.typeCode;
        }

        public @Nullable Long getAmount() {
            return this.amount;
        }

        public @Nullable Integer getItemCount() {
            return this.itemCount;
        }

        public @Nullable FundsAvailabilitySubRecord getFundsAvailabilitySubRecord() {
            return this.fundsAvailabilitySubRecord;
        }
    }
}

