/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.bai.v2.record.account;

import co.kuali.bai.v2.domain.RecordCode;
import co.kuali.bai.v2.record.AbstractRecord;
import co.kuali.bai.v2.record.ValueUtils;
import co.kuali.bai.v2.record.continuation.ContinuationRecord;
import java.util.Map;
import java.util.Objects;

public final class AccountTrailerRecord
extends AbstractRecord {
    private static final int INDEX_ACCOUNT_CONTROL_TOTAL = 1;
    private static final int INDEX_NUMBER_OF_RECORDS = 2;
    private final long accountControlTotal;
    private final int numberOfRecords;

    private AccountTrailerRecord(String recordString, ContinuationRecord ... continuationRecords) {
        super(recordString, continuationRecords);
        this.accountControlTotal = ValueUtils.requiredValueIsLong("accountControlTotal", this.fields[1]);
        this.numberOfRecords = ValueUtils.requiredValueIsPositiveInteger("numberOfRecords", this.fields[2]);
    }

    public static AccountTrailerRecord create(String recordString, ContinuationRecord ... continuationRecords) {
        return new AccountTrailerRecord(recordString, continuationRecords);
    }

    @Override
    public int expectedNumberOfFields(String[] localFields) {
        return 3;
    }

    @Override
    public Map<String, Integer> getRequiredFieldsNameToIndexMapping() {
        return Map.ofEntries(Map.entry("recordCode", 0), Map.entry("accountControlTotal", 1), Map.entry("numberOfRecords", 2));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AccountTrailerRecord)) {
            return false;
        }
        AccountTrailerRecord that = (AccountTrailerRecord)obj;
        return this.accountControlTotal == that.accountControlTotal && this.numberOfRecords == that.numberOfRecords;
    }

    public int hashCode() {
        return Objects.hash(this.accountControlTotal, this.numberOfRecords);
    }

    public String toString() {
        return "AccountTrailerRecord{accountControlTotal=" + this.accountControlTotal + ", numberOfRecords=" + this.numberOfRecords + "}";
    }

    @Override
    public RecordCode getRecordCode() {
        return RecordCode.ACCOUNT_TRAILER;
    }

    public long getAccountControlTotal() {
        return this.accountControlTotal;
    }

    public int getNumberOfRecords() {
        return this.numberOfRecords;
    }
}

